package com.enited.union.http.api;

import com.hjq.http.config.IRequestApi;

/**
 * author : ZhengYuanle
 * time   : 2022/6/29
 * desc   : 获取验证码
 */
public class GetCodeApi implements IRequestApi {

    @Override
    public String getApi() {
        return "auth/send/code";
    }


    private String mobile;
    /**
     * 1 REGISTER：注册， 2 MODIFY_PASSWORD：重置密码， 3 MODIFY_PHONE：重置手机号， 4 BIND_BANK_CARD：绑卡， 5 WITHDRAW：提现
     */
    private String templateEnum;
    /**
     * 验证用户是否存在：0不验证1验证
     */
    private int checkUser;

    public GetCodeApi setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public GetCodeApi setCheckUser(int checkUser) {
        this.checkUser = checkUser;
        return this;
    }

    public GetCodeApi setType(int type) {
        switch (type) {
            case 1:
                this.templateEnum = "REGISTER";
                break;
            case 2:
                this.templateEnum = "MODIFY_PASSWORD";
                break;
            case 3:
                this.templateEnum = "MODIFY_PHONE";
                break;
            case 4:
                this.templateEnum = "BIND_BANK_CARD";
                break;
            case 5:
                this.templateEnum = "WITHDRAW";
                break;
        }
        return this;
    }
}
