package com.enited.union.entity;

/**
 * author : ZhengYuanle
 * time   : 2022/6/30
 * desc   : 用户详细信息实体
 */
public class UserDetailsEntity {
    /**
     * 用户id
     */
    private String uid;
    /**
     * 用户账号
     */
    private String account;
    /**
     * 真实姓名
     */
    private String realName;
    /**
     * 生日 yyyy-MM-dd
     */
    private String birthday;
    /**
     * 证件类型 字典表 10：身份证 11：护照 12：军官证 13：士兵证 14：回乡证 15：户口本 16：警官证 17：台胞证 22：其他 默认为10：身份证
     */
    private int idCardType;
    /**
     * 身份证号码
     */
    private String idCard;
    /**
     * 国徽面
     */
    private String idCardJustP;
    /**
     * 人像面
     */
    private String idCardBackP;
    /**
     * 人脸留存照片
     */
    private String faceImageP;
    /**
     * 开户结果
     */
    private String openResult;
    /**
     * 手机号码
     */
    private String phone;
    /**
     * 用户地址
     */
    private String address;
    /**
     * 用户登陆类型，h5,wechat,routine,app
     */
    private String loginType;
    /**
     * 帐号状态（0正常 1停用）
     */
    private int status;
    /**
     * 开户银行标识 见=bank表
     */
    private String bankId;
    /**
     * 开户账户
     */
    private String bankCode;
    /**
     * 支行名称
     */
    private String bankSubname;
    /**
     * 提现方式 0手动提现 1自动提现
     */
    private int cashType;
    /**
     * 绑卡状态 0未绑卡 1 已绑卡 2绑卡失效
     */
    private int bindCardState;
    /**
     * 开户状态 0 待开户  1开户中  2开户成功 3开户失败 4已开户待激活
     * 除了0和3，其他的状态都是已经存在于连连系统
     */
    private int openAccountState;
    /**
     * 银行名称
     */
    private String bankName;
    /**
     * 审核状态
     */
    private int verifyStatus;
    /**
     * 实名认证状态 0 未认证  1已认证
     */
    private int realAuthState;
    /**
     * 开户银行市ID
     */
    private String cityId;

    /**
     * 开户银行市
     */
    private String cityName;

    /**
     * 开户银行省ID
     */
    private String provinceId;

    /**
     * 开户银行省
     */
    private String provinceName;
    /**
     * 性别
     */
    private String gender;
    /**
     * 民族
     */
    private String nation;
    /**
     * 有效期限，YYYY.MM.DD-YYYY.MM.DD 或 YYYY.MM.DD-长期
     */
    private String validityPeriod;
    /**
     * 发证机关
     */
    private String issuedBy;
    /**
     * E签宝个人账号ID
     */
    private String accountId;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public int getIdCardType() {
        return idCardType;
    }

    public void setIdCardType(int idCardType) {
        this.idCardType = idCardType;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getIdCardJustP() {
        return idCardJustP;
    }

    public void setIdCardJustP(String idCardJustP) {
        this.idCardJustP = idCardJustP;
    }

    public String getIdCardBackP() {
        return idCardBackP;
    }

    public void setIdCardBackP(String idCardBackP) {
        this.idCardBackP = idCardBackP;
    }

    public String getFaceImageP() {
        return faceImageP;
    }

    public void setFaceImageP(String faceImageP) {
        this.faceImageP = faceImageP;
    }

    public String getOpenResult() {
        return openResult;
    }

    public void setOpenResult(String openResult) {
        this.openResult = openResult;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLoginType() {
        return loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankSubname() {
        return bankSubname;
    }

    public void setBankSubname(String bankSubname) {
        this.bankSubname = bankSubname;
    }

    public int getCashType() {
        return cashType;
    }

    public void setCashType(int cashType) {
        this.cashType = cashType;
    }

    public int getBindCardState() {
        return bindCardState;
    }

    public void setBindCardState(int bindCardState) {
        this.bindCardState = bindCardState;
    }

    public int getOpenAccountState() {
        return openAccountState;
    }

    public void setOpenAccountState(int openAccountState) {
        this.openAccountState = openAccountState;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public int getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(int verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public int getRealAuthState() {
        return realAuthState;
    }

    public void setRealAuthState(int realAuthState) {
        this.realAuthState = realAuthState;
    }

    public String getCityId() {
        return cityId;
    }

    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public String getValidityPeriod() {
        return validityPeriod;
    }

    public void setValidityPeriod(String validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public String getIssuedBy() {
        return issuedBy;
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }
}
