package com.enited.union.app;

import com.enited.union.listener.OnBankResultListener;
import com.enited.union.listener.OnResultListener;

/**
 * author : ZhengYuanle
 * time   : 2022/9/21
 * desc   : 存储回调接口
 */
public class CallBackInstance {

    private static volatile CallBackInstance sInstance = null;

    private OnResultListener mOnResultListener = null;
    private OnBankResultListener mOnBankResultListener = null;

    public OnResultListener getOnResultListener() {
        return mOnResultListener;
    }

    public void setOnResultListener(OnResultListener mOnResultListener) {
        this.mOnResultListener = mOnResultListener;
    }

    public OnBankResultListener getOnBankResultListener() {
        return mOnBankResultListener;
    }

    public void setOnBankResultListener(OnBankResultListener mOnBankResultListener) {
        this.mOnBankResultListener = mOnBankResultListener;
    }

    public static CallBackInstance getInstance() {
        if (sInstance == null) {
            synchronized (CallBackInstance.class) {
                if (sInstance == null) {
                    sInstance = new CallBackInstance();
                }
            }
        }
        return sInstance;
    }
}
