/*
 * Decompiled with CFR 0.152.
 */
package cn.enaium.xicons.jfx.utility;

import javafx.collections.ObservableList;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.transform.Affine;

public class ExtendPath
extends Path {
    public void moveTo(double x, double y) {
        this.getElements().add((Object)new MoveTo(x, y));
    }

    public void lineTo(double x, double y) {
        this.getElements().add((Object)new LineTo(x, y));
    }

    public void quadTo(double controlX, double controlY, double x, double y) {
        this.getElements().add((Object)new QuadCurveTo(controlX, controlY, x, y));
    }

    public void curveTo(double controlX1, double controlY1, double controlX2, double controlY2, double x, double y) {
        this.getElements().add((Object)new CubicCurveTo(controlX1, controlY1, controlX2, controlY2, x, y));
    }

    public void arcTo(double radiusX, double radiusY, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        this.getElements().add((Object)new ArcTo(radiusX, radiusY, xAxisRotation, x, y, largeArcFlag, sweepFlag));
    }

    public void close() {
        this.getElements().add((Object)new ClosePath());
    }

    public void horizontalLineTo(double x) {
        this.getElements().add((Object)new LineTo(x, this.getCurrentY()));
    }

    public void verticalLineTo(double y) {
        this.getElements().add((Object)new LineTo(this.getCurrentX(), y));
    }

    public void scale(double x, double y) {
        Affine affine = new Affine();
        affine.appendScale(x, y);
        this.getTransforms().add((Object)affine);
    }

    private double getCurrentX() {
        ObservableList elements = this.getElements();
        if (elements.isEmpty()) {
            return 0.0;
        }
        PathElement last = (PathElement)elements.get(elements.size() - 1);
        if (last instanceof MoveTo) {
            return ((MoveTo)last).getX();
        }
        if (last instanceof LineTo) {
            return ((LineTo)last).getX();
        }
        if (last instanceof QuadCurveTo) {
            return ((QuadCurveTo)last).getX();
        }
        if (last instanceof CubicCurveTo) {
            return ((CubicCurveTo)last).getX();
        }
        if (last instanceof ArcTo) {
            return ((ArcTo)last).getX();
        }
        return 0.0;
    }

    private double getCurrentY() {
        ObservableList elements = this.getElements();
        if (elements.isEmpty()) {
            return 0.0;
        }
        PathElement last = (PathElement)elements.get(elements.size() - 1);
        if (last instanceof MoveTo) {
            return ((MoveTo)last).getY();
        }
        if (last instanceof LineTo) {
            return ((LineTo)last).getY();
        }
        if (last instanceof QuadCurveTo) {
            return ((QuadCurveTo)last).getY();
        }
        if (last instanceof CubicCurveTo) {
            return ((CubicCurveTo)last).getY();
        }
        if (last instanceof ArcTo) {
            return ((ArcTo)last).getY();
        }
        return 0.0;
    }
}

