package cn.elwy.common.util.sysinfo;

import java.util.List;

class WindowsSystemInfo implements MachineCodeService {

	public String getCPUSN() {
		try {
			String[] command = new String[] { "wmic", "cpu", "get", "ProcessorId" };
			List<String> content = CommandUtil.runCommandToList(command);
			if (content != null && content.size() > 1) {
				return content.get(1);
			}
		} catch (Exception e) {
			throw new RuntimeException("读取CPU列号失败！");
		}
		return "";
	}

	public String getMotherboardSN() {
		try {
			String[] command = new String[] { "wmic", "baseboard", "get", "SerialNumber" };
			List<String> content = CommandUtil.runCommandToList(command);
			if (content != null && content.size() > 1) {
				return content.get(1);
			}
		} catch (Exception e) {
			throw new RuntimeException("读取主板序列号失败！");
		}
		return "";
	}

	public String getHardDiskSN() {
		try {
			String[] command = new String[] { "wmic", "diskdrive", "get", "SerialNumber" };
			List<String> content = CommandUtil.runCommandToList(command);
			if (content != null && content.size() > 1) {
				return content.get(1);
			}
		} catch (Exception e) {
			try {
				String[] command = new String[] { "wmic", "diskdrive", "get", "signature" };
				List<String> content = CommandUtil.runCommandToList(command);
				if (content != null && content.size() > 1) {
					return content.get(1);
				}
			} catch (Exception ex) {
				throw new RuntimeException("获取硬盘序列号signature出错,无效硬盤序列号被读取");
			}
		}
		return "";
	}

}
