package cn.elwy.common.util.sysinfo;

/**
 * 操作系统工具类，可以获取和判断操作系统类型
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class OSUtil {

	private static String OS = System.getProperty("os.name").toLowerCase();

	private OSUtil() {
	}

	/**
	 * 获取操作系统名称
	 * @return os.name
	 */
	public static String getOSName() {
		return System.getProperty("os.name");
	}

	/**
	 * 获取操作系统版本
	 * @return os.version
	 */
	public static String getOSVersion() {
		return System.getProperty("os.version");
	}

	/**
	 * 获取操作系统特性
	 * @return os.arch
	 */
	public static String getOSArch() {
		return System.getProperty("os.arch");
	}

	public static boolean isLinux() {
		return OS.indexOf("linux") >= 0;
	}

	public static boolean isMacOS() {
		return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") < 0;
	}

	public static boolean isMacOSX() {
		return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") > 0;
	}

	public static boolean isWindows() {
		return OS.indexOf("windows") >= 0;
	}

	public static boolean isOS2() {
		return OS.indexOf("os/2") >= 0;
	}

	public static boolean isSolaris() {
		return OS.indexOf("solaris") >= 0;
	}

	public static boolean isSunOS() {
		return OS.indexOf("sunos") >= 0;
	}

	public static boolean isMPEiX() {
		return OS.indexOf("mpe/ix") >= 0;
	}

	public static boolean isHPUX() {
		return OS.indexOf("hp-ux") >= 0;
	}

	public static boolean isAix() {
		return OS.indexOf("aix") >= 0;
	}

	public static boolean isOS390() {
		return OS.indexOf("os/390") >= 0;
	}

	public static boolean isFreeBSD() {
		return OS.indexOf("freebsd") >= 0;
	}

	public static boolean isIrix() {
		return OS.indexOf("irix") >= 0;
	}

	public static boolean isDigitalUnix() {
		return OS.indexOf("digital") >= 0 && OS.indexOf("unix") > 0;
	}

	public static boolean isNetWare() {
		return OS.indexOf("netware") >= 0;
	}

	public static boolean isOSF1() {
		return OS.indexOf("osf1") >= 0;
	}

	public static boolean isOpenVMS() {
		return OS.indexOf("openvms") >= 0;
	}

	/**
	 * 获取操作系统类型
	 * @return 操作系统类型
	 */
	public static OSType getOSType() {
		if (isAix()) {
			return OSType.AIX;
		} else if (isDigitalUnix()) {
			return OSType.Digital_Unix;
		} else if (isFreeBSD()) {
			return OSType.FreeBSD;
		} else if (isHPUX()) {
			return OSType.HP_UX;
		} else if (isIrix()) {
			return OSType.Irix;
		} else if (isLinux()) {
			return OSType.Linux;
		} else if (isMacOS()) {
			return OSType.Mac_OS;
		} else if (isMacOSX()) {
			return OSType.Mac_OS_X;
		} else if (isMPEiX()) {
			return OSType.MPEiX;
		} else if (isNetWare()) {
			return OSType.NetWare_411;
		} else if (isOpenVMS()) {
			return OSType.OpenVMS;
		} else if (isOS2()) {
			return OSType.OS2;
		} else if (isOS390()) {
			return OSType.OS390;
		} else if (isOSF1()) {
			return OSType.OSF1;
		} else if (isSolaris()) {
			return OSType.Solaris;
		} else if (isSunOS()) {
			return OSType.SunOS;
		} else if (isWindows()) {
			return OSType.Windows;
		} else {
			return OSType.Others;
		}
	}

	/**
	 * 操作系统类型
	 */
	public enum OSType {

		Any("any"), Linux("Linux"), Mac_OS("Mac OS"), Mac_OS_X("Mac OS X"), Windows("Windows"), OS2("OS/2"), Solaris(
				"Solaris"), SunOS("SunOS"), MPEiX("MPE/iX"), HP_UX("HP-UX"), AIX("AIX"), OS390("OS/390"), FreeBSD(
						"FreeBSD"), Irix("Irix"), Digital_Unix(
								"Digital Unix"), NetWare_411("NetWare"), OSF1("OSF1"), OpenVMS("OpenVMS"), Others("Others");

		private String text;

		private OSType(String text) {
			this.text = text;
		}

		public String toString() {
			return text;
		}

	}

}