package cn.elwy.common.util.sysinfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * 获取MAC地址工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class MacAddress {

	private MacAddress() {
	}

	public static void main(String[] args) {
		getAllLocalHostIP();
		System.out.println(getLocalHostName());
		Enumeration<NetworkInterface> netInterfaces = null;
		try {
			netInterfaces = NetworkInterface.getNetworkInterfaces();
			while (netInterfaces.hasMoreElements()) {
				NetworkInterface ni = netInterfaces.nextElement();
				// System.out.println("DisplayName:" + ni.getDisplayName());
				// System.out.println("Name:" + ni.getName());
				Enumeration<InetAddress> ips = ni.getInetAddresses();
				while (ips.hasMoreElements()) {
					String ip = String.format("%02X%s", ips.nextElement().getHostAddress(), "-");
					System.out.println("IP:" + ip);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		// String allipaddress;
		// ArrayList ar = new ArrayList();
		// Enumeration netInterfaces = null;
		// try {
		// netInterfaces = NetworkInterface.getNetworkInterfaces();
		// } catch (SocketException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		// while (netInterfaces.hasMoreElements()) {
		// NetworkInterface ni = (NetworkInterface) netInterfaces.nextElement();
		//
		// Enumeration cardipaddress = ni.getInetAddresses();
		// InetAddress ip = (InetAddress) cardipaddress.nextElement();
		// if(!ip.getHostAddress().equalsIgnoreCase("127.0.0.1") )
		// { ar.add(ni.getName()+":");
		// allipaddress=ip.getHostAddress();
		// while(cardipaddress.hasMoreElements())
		// {
		// ip = (InetAddress) cardipaddress.nextElement();
		// allipaddress=allipaddress+" , "+ip.getHostAddress();
		//
		// }
		// ar.add(allipaddress);
		//
		// }
		// else
		// continue;
		//
		//
		// }
		// for(int i=0;i<ar.size();)
		// {
		// System.out.println(ar.get(i++));
		// }
		//

		getMACAddress("192.168.142.1");
		//
		// System.out.println(getMACAddress());
		// System.out.println(getMACAddress("127.0.0.1"));
		// try {
		// InetAddress address = InetAddress.getLocalHost();
		// System.out.println(getMACAddress(address));
		// } catch (UnknownHostException e) {
		// e.printStackTrace();
		// }
		// List<String> list = getLocalMacs();
		// for (int i = 0; i < list.size(); i++) {
		// String valuee = list.get(i);
		// System.out.println("MACs ===" + valuee);
		// }
	}

	/**
	 * 获取本地IP的MAC地址
	 * @return
	 */
	public static String getMACAddress() {
		try {
			InetAddress address = InetAddress.getLocalHost();
			return getMACAddress(address);
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 根据IP获取指定的MAC地址
	 * @param ip
	 * @return
	 */
	public static String getMACAddress(String ip) {
		if ("localhost".equalsIgnoreCase(ip) || "127.0.0.1".equals(ip)) {
			return getMACAddress();
		}
		try {
			InetAddress address = InetAddress.getByName(ip);
			return getMACAddress(address);
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 根据InetAddress获取指定的MAC地址
	 * @param address
	 * @return
	 */
	public static String getMACAddress(InetAddress address) {
		try {
			/*- 获得当前主机NetworkInterface,然后读取硬件地址 */
			NetworkInterface ni = NetworkInterface.getByInetAddress(address);
			if (ni != null) {
				byte[] mac = ni.getHardwareAddress();
				if (mac != null) {
					/*- 提取每个数组的MAC地址并使用以下格式将它转换成十六进制：08-00-27-DC-4A-9E */
					StringBuffer macAddress = new StringBuffer();
					for (int i = 0; i < mac.length; i++) {
						macAddress.append(String.format("%02X%s", mac[i], (i < mac.length - 1) ? "-" : ""));
						System.out.format("%02X%s", mac[i], (i < mac.length - 1) ? "-" : "");
					}
					System.out.println();
					return macAddress.toString();
				} else {
					System.out.println("Address doesn't exist or is not accessible.");
				}
			} else {
				System.out.println("Network Interface for the specified address is not found.");
			}
		} catch (SocketException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 获取本地系统的所有Mac地址
	 * @return
	 */
	public static List<String> getLocalMacs() {
		String os = System.getProperty("os.name");
		List<String> list = new ArrayList<String>();
		if (os != null && os.startsWith("Windows")) {
			String command = "cmd.exe /c ipconfig /all";
			return getLocalMac(command);
		} else if (os != null && os.startsWith("Linux")) {
			String command = "/bin/sh -c ifconfig -a";
			return getLocalMac(command);
		}
		return list;
	}

	public static String getLocalHostName() {
		String hostName = "";
		try {
			InetAddress addr = InetAddress.getLocalHost();
			hostName = addr.getHostName();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return hostName;
	}

	public static String[] getAllLocalHostIP() {
		String[] ret = null;
		try {
			String hostName = getLocalHostName();
			if (hostName != null && !hostName.isEmpty()) {
				InetAddress[] addrs = InetAddress.getAllByName(hostName);
				if (addrs != null && addrs.length > 0) {
					ret = new String[addrs.length];
					for (int i = 0; i < addrs.length; i++) {
						ret[i] = addrs[i].getHostAddress();
						System.out.println(ret[i]);
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ret;
	}

	/**
	 * 获取本地系统的所有Mac地址
	 * @param command 操作系统对应的操作命令
	 * @return
	 */
	public static List<String> getLocalMac(String command) {
		String address = null;
		List<String> list = new ArrayList<String>();
		try {
			Process p = Runtime.getRuntime().exec(command);
			BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line = null;
			while ((line = br.readLine()) != null) {
				if (line
						.matches(".*[:]{1}.[0-9A-Z]{2}[-][0-9A-Z]{2}[-][0-9A-Z]{2}[-][0-9A-Z]{2}[-][0-9A-Z]{2}[-][0-9A-Z]{2}$")) {
					int index = line.indexOf(":");
					index += 2;
					address = line.substring(index);
					list.add(address);
				}
			}
			br.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return list;
	}

	/**
	 * 获取Linux操作系统的Mac地址
	 * @return
	 */
	public static String getLinuxMac() {
		String address = null;
		try {
			String command = "/bin/sh -c ifconfig -a";
			Process p = Runtime.getRuntime().exec(command);
			BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line;
			while ((line = br.readLine()) != null) {
				if (line.indexOf("HWaddr") > 0) {
					int index = line.indexOf("HWaddr") + "HWaddr".length();
					address = line.substring(index);
					break;
				}
			}
			br.close();
		} catch (IOException e) {
		}
		return address;
	}

}
