package cn.elwy.common.util.sysinfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class LinuxSystemInfo implements MachineCodeService {

	public String getCPUSN() {
		String result = "";
		String CPU_ID_CMD = "dmidecode -t 4 | grep ID |sort -u |awk -F': ' '{print $2}'";
		Process p;
		try {
			p = Runtime.getRuntime().exec(new String[] { "sh", "-c", CPU_ID_CMD });// 管道
			BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line;
			while ((line = br.readLine()) != null) {
				result += line;
				break;
			}
			br.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		if (result.trim().length() < 1 || result == null) {
			result = "无效CPU序列号被读取";
		}
		return result.replace(" ", "");
	}

	public String getMotherboardSN() {
		String result = "";
		String CPU_ID_CMD = "dmidecode -t 2 | grep 'Serial Number' |sort -u |awk -F': ' '{print $2}'";
		Process p;
		try {
			p = Runtime.getRuntime().exec(new String[] { "sh", "-c", CPU_ID_CMD });// 管道
			BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line;
			while ((line = br.readLine()) != null) {
				result += line;
				break;
			}
			br.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		if (result.trim().length() < 1 || result == null) {
			result = "无效主板序列号被读取";
		}
		return result.replace(" ", "");
	}

	public String getDiskSerial() {
		return getHardDiskSN();
	}

	public String getHardDiskSN() {
		String sn = "";
		try {
			if (isSCSIorIDEHD() == "scsi") {
				// 注意如果是ubuntu等系统用户，本身没有root权限，请先：chmod 777 /dev/sda
				String command = "hdparm -i /dev/sda";
				Process p;

				p = Runtime.getRuntime().exec(command);
				BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
				String line;
				while ((line = br.readLine()) != null) {
					if (line.contains("SerialNo")) {
						int index = line.indexOf("SerialNo") + "SerialNo".length() + 1;
						sn = line.substring(index);
						break;
					}
				}
				br.close();

			} else if (isSCSIorIDEHD() == "ide") {
				// 注意如果是ubuntu等系统用户，本身没有root权限，请先：chmod 777 /dev/sda
				String command = "hdparm -i /dev/hda";
				Process p;

				p = Runtime.getRuntime().exec(command);
				BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
				String line;
				while ((line = br.readLine()) != null) {
					if (line.contains("SerialNo")) {
						int index = line.indexOf("SerialNo") + "SerialNo".length() + 1;
						sn = line.substring(index);
						break;
					}
				}
				br.close();

			} else {
				sn = "unknown";
			}

		} catch (Exception e) {
			// TODO: handle exception
		}
		return sn.replace(" ", "");
	}

	private static String isSCSIorIDEHD() {
		// ubuntu系统下确定有root权限
		String command = "fdisk -l";
		Process p;
		try {
			p = Runtime.getRuntime().exec(command);
			BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
			String line;
			while ((line = br.readLine()) != null) {
				if (line.contains("sd")) {
					return "scsi";
				}
				if (line.contains("hd")) {
					return "ide";
				}
			}
			br.close();
		} catch (IOException e) {
		}
		return "unkonwn"; // 未知类型
	}

}
