package cn.elwy.common.util.sysinfo;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cn.elwy.common.util.ConvertTypeUtil;

/**
 * JVM参数获取工具
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class JvmUtil {

	private static String jvmArguments;

	public static String XX_PERM_SIZE;
	public static String XX_MAX_NEW_SIZE;
	public static String XX_MAX_PERM_SIZE;
	public static String XMS;
	public static String XMX;

	static {
		init();

		XX_PERM_SIZE = "-XX:PermSize=\\d+[\\.]?\\d*\\w";
		XX_MAX_NEW_SIZE = "-XX:MaxNewSize=\\d+[\\.]?\\d*\\w";
		XX_MAX_PERM_SIZE = "-XX:MaxPermSize=\\d+[\\.]?\\d*\\w";
		XMS = "-Xms\\d+[\\.]?\\d*\\w";
		XMX = "-Xmx\\d+[\\.]?\\d*\\w";
	}

	private JvmUtil() {
	}

	public static void init() {
		RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
		List<String> arguments = runtimeMxBean.getInputArguments();
		StringBuffer vmArgs = new StringBuffer();
		int size = arguments.size();
		for (int i = 0; i < size; i++) {
			String argument = arguments.get(i);
			vmArgs.append(argument);
			if (i != size - 1) {
				vmArgs.append("###");
			}
		}
		jvmArguments = vmArgs.toString();
	}

	public static void main(String[] args) {
		jvmArguments = "-agentlib:jdwp=transport=dt_socket,suspend=y,address=localhost:55859###-Xms1024m###-Xmx1024m###-XX:PermSize=256M###-XX:MaxNewSize=520m-XX:MaxPermSize=512m###-Dcatalina.base=X:\\server\\sofa-tomcat-6###-Dcatalina.home=X:\\server\\sofa-tomcat-6###-Dwtp.deploy=X:\\server\\sofa-tomcat-6\\webapps###-Djava.endorsed.dirs=X:\\server\\sofa-tomcat-6\\endorsed###-Dfile.encoding=UTF-8###";
		System.out.println(getXXPermSize());
		System.out.println(getXXMaxNewSize());
		System.out.println(getXXMaxPermSize());
		System.out.println(getXms());
		System.out.println(getXmx());
	}

	public static Integer getXXPermSize() {
		return getInteger(XX_PERM_SIZE);
	}

	public static Integer getXXMaxNewSize() {
		return getInteger(XX_MAX_NEW_SIZE);
	}

	public static Integer getXXMaxPermSize() {
		return getInteger(XX_MAX_PERM_SIZE);
	}

	public static Integer getXms() {
		return getInteger(XMS);
	}

	public static Integer getXmx() {
		return getInteger(XMX);
	}

	/**
	 * 根据正则表达式，读取相应的整型值
	 * @param regex
	 * @return
	 */
	private static Integer getInteger(String regex) {
		Integer result = 0;
		int UNIT = 1024;
		Matcher matcher = Pattern.compile(regex).matcher(jvmArguments);
		if (matcher.find()) {
			String group = matcher.group();
			String value = group.replaceAll("[^\\d\\.]*", "");
			result = ConvertTypeUtil.toInteger(value, 0);
			if (result != null) {
				group = group.toLowerCase();
				if (group.endsWith("g")) {
					result *= UNIT;
				} else if (group.endsWith("k")) {
					result /= UNIT;
				}
			}
		}
		return result;
	}

}
