package cn.elwy.common.util.sysinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import cn.elwy.common.Constant;
import cn.elwy.common.util.CloseUtil;

public class CommandUtil {

	/**
	 * 运行命令
	 * @param command
	 * @throws IOException
	 */
	public static String runCommand(String... command) throws IOException {
		Process process = null;
		Scanner scanner = null;
		try {
			if (command != null && command.length == 1) {
				process = Runtime.getRuntime().exec(command[0]);
			} else {
				process = Runtime.getRuntime().exec(command);
			}
			String encoding = System.getProperty("file.encoding");
			scanner = new Scanner(process.getInputStream(), encoding);
			StringBuffer content = new StringBuffer();
			while (scanner.hasNext()) {
				content.append(scanner.next());
				if (scanner.hasNext()) {
					content.append(Constant.LINE_SEPARATOR);
				}
			}
			return content.toString();
		} finally {
			if (process != null) {
				CloseUtil.close(scanner);
				CloseUtil.close(process.getErrorStream());
				CloseUtil.close(process.getInputStream());
				CloseUtil.close(process.getOutputStream());
				process.destroy();
			}
		}
	}

	public static List<String> runCommandToList(String... command) throws IOException {
		Process process = null;
		Scanner scanner = null;
		try {
			if (command != null && command.length == 1) {
				process = Runtime.getRuntime().exec(command[0]);
			} else {
				process = Runtime.getRuntime().exec(command);
			}
			String encoding = System.getProperty("file.encoding");
			scanner = new Scanner(process.getInputStream(), encoding);
			List<String> content = new ArrayList<String>();
			while (scanner.hasNext()) {
				content.add(scanner.next());
			}
			return content;
		} finally {
			if (process != null) {
				CloseUtil.close(scanner);
				CloseUtil.close(process.getErrorStream());
				CloseUtil.close(process.getInputStream());
				CloseUtil.close(process.getOutputStream());
				process.destroy();
			}
		}
	}

}
