package cn.elwy.common.util.sort;

import java.text.Format;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.Map;

/**
 * 排序条件实体类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class SortCondition {

	/** 是否升序 */
	private boolean isAsc;
	/** 属性名称或方法名称(方法名称带括号) */
	private String name;
	/** 排序比较器 */
	private Comparator<Object> comparator;
	/** 格式化类 */
	private Format format;
	/** ParsePosition */
	private ParsePosition parsePosition;
	/** 排序的map */
	private Map<?, ?> map;
	/** 是否表格形式获取数据 */
	private boolean isTable;
	/** 排序的map按值排序 */
	private boolean isSortMapByValue;
	/** 如果元素为Map，是否支持方法名作为Key */
	private boolean isSupportMap;

	public SortCondition(boolean isAsc, String name) {
		this(isAsc, name, null);
	}

	public SortCondition(boolean isAsc, String name, Comparator<Object> comparator) {
		this.isAsc = isAsc;
		this.name = name;
		this.comparator = comparator;
	}

	public boolean isAsc() {
		return isAsc;
	}

	public void setAsc(boolean isAsc) {
		this.isAsc = isAsc;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Comparator<Object> getComparator() {
		return comparator;
	}

	public void setComparator(Comparator<Object> comparator) {
		this.comparator = comparator;
	}

	public Format getFormat() {
		return format;
	}

	public void setFormat(Format format) {
		this.format = format;
	}

	public ParsePosition getParsePosition() {
		return parsePosition;
	}

	public void setParsePosition(ParsePosition parsePosition) {
		this.parsePosition = parsePosition;
	}

	public Map<?, ?> getMap() {
		return map;
	}

	public void setMap(Map<?, ?> map) {
		this.map = map;
	}

	public boolean isTable() {
		return isTable;
	}

	public void setTable(boolean isTable) {
		this.isTable = isTable;
	}

	public boolean isSortMapByValue() {
		return isSortMapByValue;
	}

	public void setSortMapByValue(boolean isSortMapByValue) {
		this.isSortMapByValue = isSortMapByValue;
	}

	public boolean isSupportMap() {
		return isSupportMap;
	}

	public void setSupportMap(boolean isSupportMap) {
		this.isSupportMap = isSupportMap;
	}

}
