package cn.elwy.common.util.sort;

import java.io.File;
import java.util.Comparator;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class FileComparator {

	private FileComparator() {
	}

	/**
	 * 根据排序方式获取Comparator
	 * @param isAsc 是否升序
	 * @return Comparator 排序比较器
	 */
	public static Comparator<File> getComparator(final boolean isAsc) {
		return new Comparator<File>() {

			public int compare(File file1, File file2) {
				int result = 0;
				if (file1.isDirectory() && file2.isFile()) {
					result = 1;
				} else if (file1.isFile() && file2.isDirectory()) {
					result = -1;
				} else {
					result = file1.getName().compareTo(file2.getName());
				}
				return isAsc ? result : -result;
			}

		};
	}

}
