package cn.elwy.common.util.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class XmlBean {

	private String nodeName;
	private Object nodeValue;
	private Map<String, Object> attributeMap = new HashMap<String, Object>();
	private List<XmlBean> children;

	public XmlBean() {

	}

	public XmlBean(String nodeName) {
		this.nodeName = nodeName;
	}

	public XmlBean(String nodeName, Object nodeValue) {
		this.nodeName = nodeName;
		this.nodeValue = nodeValue;
	}

	public XmlBean(String nodeName, Object nodeValue, Map<String, Object> attribute, List<XmlBean> chield) {
		this.nodeName = nodeName;
		this.nodeValue = nodeValue;
		this.attributeMap = attribute;
		this.children = chield;
	}

	/**
	 * @return the nodeName
	 */
	public String getNodeName() {
		return nodeName;
	}

	/**
	 * @param nodeName the nodeName to set
	 */
	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	/**
	 * @return the nodeValue
	 */
	public Object getNodeValue() {
		return nodeValue;
	}

	/**
	 * @param nodeValue the nodeValue to set
	 */
	public void setNodeValue(Object nodeValue) {
		this.nodeValue = nodeValue;
	}

	/**
	 * @return the attribute
	 */
	public Map<String, Object> getAttribute() {
		return attributeMap;
	}

	/**
	 * @param attribute the attribute to set
	 */
	public void setAttribute(Map<String, Object> attribute) {
		this.attributeMap = attribute;
	}

	/**
	 * @return the chield
	 */
	public List<XmlBean> getChildren() {
		return children;
	}

	/**
	 * @param children the chield to set
	 */
	public void setChildren(List<XmlBean> children) {
		this.children = children;
	}

}
