package cn.elwy.common.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import cn.elwy.common.util.CloseUtil;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class ManifestUtil {

	private ManifestUtil() {
	}

	public static Manifest getManifest(String filePath) throws IOException {
		InputStream is = null;
		try {
			is = new FileInputStream(filePath);
			return getManifest(is);
		} finally {
			CloseUtil.close(is);
		}
	}

	public static Manifest getManifest(File file) throws IOException {
		InputStream is = null;
		try {
			is = new FileInputStream(file);
			return getManifest(is);
		} finally {
			CloseUtil.close(is);
		}
	}

	public static Manifest getManifest(URL url) throws IOException {
		InputStream is = null;
		try {
			is = url.openStream();
			return getManifest(is);
		} finally {
			CloseUtil.close(is);
		}
	}

	public static Manifest getManifest(InputStream is) throws IOException {
		Manifest mf = new Manifest(is);
		return mf;
	}

	public static String getValue(Manifest mf, String key) throws IOException {
		Attributes attributes = mf.getMainAttributes();
		return attributes.getValue(key);
	}

}