package cn.elwy.common.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class ListFileFilter implements FileFilter {

	private boolean ignoreCase;
	private boolean isExclude;
	private String regex;
	private FilterType filterType;

	public ListFileFilter(String regex) {
		this(regex, false, true);
	}

	public ListFileFilter(String regex, boolean ignoreCase, boolean isExclude) {
		this.regex = regex;
		this.ignoreCase = ignoreCase;
		this.isExclude = isExclude;
	}

	@Override
	public boolean accept(File file) {
		String fileName = file.getName();
		if (filterType == FilterType.FILE) {
			if (file.isFile()) {
				return isMatcher(fileName);
			} else {
				return true;
			}
		} else if (filterType == FilterType.DIRECTORY) {
			if (file.isDirectory()) {
				return isMatcher(fileName);
			} else {
				return true;
			}
		} else {
			return isMatcher(fileName);
		}
	}

	private boolean isMatcher(String fileName) {
		boolean isMatcher = isMatcher(regex, fileName, ignoreCase);
		if (isExclude) {
			return !isMatcher;
		} else {
			return isMatcher;
		}
	}

	/**
	 * 判断内容是否匹配正则表达式
	 * @param regex 正则表达式
	 * @param text 字符串
	 * @param ignoreCase 是否忽略大小写
	 * @return
	 */
	private boolean isMatcher(String regex, String text, boolean ignoreCase) {
		if (ignoreCase) {
			return Pattern.compile(regex, Pattern.CASE_INSENSITIVE).matcher(text).find();
		} else {
			return Pattern.compile(regex).matcher(text).find();
		}
	}

	public boolean isIgnoreCase() {
		return ignoreCase;
	}

	public void setIgnoreCase(boolean ignoreCase) {
		this.ignoreCase = ignoreCase;
	}

	public boolean isExclude() {
		return isExclude;
	}

	public void setExclude(boolean isExclude) {
		this.isExclude = isExclude;
	}

	public String getRegex() {
		return regex;
	}

	public void setRegex(String regex) {
		this.regex = regex;
	}

	public FilterType getFilterType() {
		return filterType;
	}

	public void setFilterType(FilterType filterType) {
		this.filterType = filterType;
	}

	public enum FilterType {
		ALL, FILE, DIRECTORY
	}
}
