package cn.elwy.common.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 获取文件或输入流编码
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class CharsetDetectorUtil {

	private static final Set<CharsetDetector> charsetDetectorList = new LinkedHashSet<CharsetDetector>();

	private CharsetDetectorUtil() {
	}

	static {
		init();
	}

	public static void init() {
		addCharsetDetector(CharsetDetector.getInstance());
		addCharsetDetector(CharsetDetectorMozilla.getInstance());
	}

	public static void addCharsetDetector(CharsetDetector charsetDetector) {
		charsetDetectorList.add(charsetDetector);
	}

	public static Set<CharsetDetector> getCharsetdetectorlist() {
		return charsetDetectorList;
	}

	/**
	 * 读取文件的编码
	 * @param file 文件
	 * @return 文件编码格式
	 * @throws IOException
	 */
	public static String getCharsetName(File file) throws IOException {
		return getCharsetName(file.getAbsolutePath());
	}

	/**
	 * 获取文件的编码格式
	 * @param filePath 文件路径
	 * @return 文件编码格式
	 * @throws IOException
	 */
	public static String getCharsetName(String filePath) throws IOException {
		for (CharsetDetector charsetDetector : charsetDetectorList) {
			String charsetName = charsetDetector.getCharsetName(filePath);
			if (charsetName != null) {
				return charsetName;
			}
		}
		return null;
	}

	/**
	 * 获取文件的编码格式
	 * @param filePath 文件路径
	 * @return 文件编码格式
	 * @throws IOException
	 */
	public static String getCharsetName(URL url) throws IOException {
		for (CharsetDetector charsetDetector : charsetDetectorList) {
			String charsetName = charsetDetector.getCharsetName(url);
			if (charsetName != null) {
				return charsetName;
			}
		}
		return null;
	}

	/**
	 * 获取文件的编码格式
	 * @param filePath 文件路径
	 * @return 文件编码格式
	 * @throws IOException
	 */
	public static String getCharsetName(InputStream is) throws IOException {
		for (CharsetDetector charsetDetector : charsetDetectorList) {
			return charsetDetector.getCharsetName(is);
		}
		return null;
	}

}