package cn.elwy.common.util;

import java.lang.reflect.Constructor;

import cn.elwy.common.exception.RunException;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class ThreadLocalType<T> extends ThreadLocal<T> {

	protected Constructor<? extends T> constructor;
	public final Object[] args;

	public ThreadLocalType(Class<? extends T> clazz, Object... args) {
		try {
			constructor = clazz.getConstructor(ReflectUtil.getClassOfArgs(args));
		} catch (Exception e) {
			throw new RunException(e.getMessage(), e);
		}
		this.args = args;
	}

	public ThreadLocalType(Constructor<T> constructor, Object... args) {
		this.constructor = constructor;
		this.args = args;
	}

	@Override
	protected T initialValue() {
		try {
			return constructor.newInstance(args);
		} catch (Throwable e) {
			throw new RunException(e.getMessage(), e);
		}
	}

}
