package cn.elwy.common.util;

import java.util.Map;
import java.util.Map.Entry;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class StringUtil {

	private static final String DEFAULT_START_MARK = "\\$\\{";
	private static final String DEFAULT_END_MARK = "\\}";

	/**
	 * 替换字符串中的变量
	 * @param source 原字符串
	 * @param msgMaps
	 * @return
	 */
	public static String replace(String source, Map<?, ?> map) {
		return replace(source, map, DEFAULT_START_MARK, DEFAULT_END_MARK);
	}

	/**
	 * 替换字符串中的变量
	 * @param source 原字符串
	 * @param msgMaps
	 * @param startMark 关键字开始标记
	 * @return
	 */
	public static String replace(String source, Map<?, ?> map, String startMark) {
		return replace(source, map, startMark, DEFAULT_END_MARK);
	}

	/**
	 * 替换字符串中的变量
	 * @param source 原字符串
	 * @param msgMaps
	 * @param startMark 关键字开始标记
	 * @param endMark 关键字结束标记
	 * @return
	 */
	public static String replace(String source, Map<?, ?> map, String startMark, String endMark) {
		String replace = source;
		StringBuilder strBuilder = new StringBuilder();
		for (Entry<?, ?> e : map.entrySet()) {
			strBuilder.append(startMark).append(e.getKey()).append(endMark);
			replace = replace.replaceAll(strBuilder.toString(), (String) e.getValue());
			strBuilder.delete(0, strBuilder.length() - 1);
		}
		return replace;
	}

	public static int getCharLength(String text) {
		// 中文字符(根据Unicode范围判断),中文字符长度为2
		return getCharLength(text, 2);
	}

	public static int getCharLength(String str, int step) {
		int m = 0;
		char arr[] = str.toCharArray();
		for (int i = 0; i < arr.length; i++) {
			char c = arr[i];
			if ((c >= 0x0391 && c <= 0xFFE5)) {
				m = m + step;
			} else if ((c >= 0x0000 && c <= 0x00FF)) {
				m = m + 1;
			}
		}
		return m;
	}

}
