package cn.elwy.common.util;

/**
 * 数学工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class MathUtil {

	private MathUtil() {
	}

	/**
	 * 根据传入的实际宽度或高度计算出缩放后的高度或宽度
	 * @param width 原始宽度
	 * @param height 原始高度
	 * @param newWidth 新的宽度
	 * @return 新的高
	 */
	public static int getScaleLength(float width, float height, int newWidth) {
		float imageScale = (float) newWidth / (float) width;
		return Math.round(height * imageScale);
	}

	/**
	 * 根据传入的实际宽度或高度计算出缩放后的高度或宽度
	 * @param width 原始宽度
	 * @param height 原始高度
	 * @param newWidth 最大宽度
	 * @param newHeight 最大高度
	 * @param isOut 大于实际尺寸
	 * @return 新的大小
	 */
	public static int[] getScaleSize(float width, float height, int newWidth, int newHeight, boolean isOut) {
		int realWidth = newWidth;
		int realHeight = getScaleLength(width, height, newWidth);

		if (isOut) {
			if (realHeight < newHeight) {
				realHeight = newHeight;
				realWidth = getScaleLength(height, width, newHeight);
			}
		} else {
			if (realHeight > newHeight) {
				realHeight = newHeight;
				realWidth = getScaleLength(height, width, newHeight);
			}
		}
		return new int[] { realWidth, realHeight };
	}

}
