package cn.elwy.common.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import cn.elwy.common.log.Logger;
import cn.elwy.common.log.LoggerFactory;

/**
 * 格式化数据工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class FormatUtil {

	private static final Logger logger = LoggerFactory.getLogger(FormatUtil.class);

	private FormatUtil() {
	}

	/**
	 * 根据格式化的类名和模式格式化指定的对象
	 * @param className 格式类全名
	 * @param pattern 模式
	 * @param value 要格式的对象
	 * @return
	 * @throws Exception
	 */
	public static String format(String className, String pattern, Object value) throws Exception {
		if (value == null) {
			return null;
		}
		Class<?> clazz = Class.forName(className);
		Object object = clazz.newInstance();
		if (object instanceof SimpleDateFormat) {
			SimpleDateFormat format = (SimpleDateFormat) object;
			format.applyPattern(pattern);
			return format.format(value);
		} else if (object instanceof DecimalFormat) {
			DecimalFormat format = (DecimalFormat) object;
			format.applyPattern(pattern);
			return format.format(value);
		}
		return value.toString();
	}

	/**
	 * 根据格式化的类名和模式格式化指定的对象，格式化错误返回缺省值
	 * @param className 格式类全名
	 * @param pattern 模式
	 * @param value 要格式的对象
	 * @param defaultValue 缺省值
	 * @return 格式化后的字符串
	 * @throws Exception
	 */
	public static String format(String className, String pattern, Object value, String defaultValue) {
		try {
			String result = format(className, pattern, value);
			if (result == null) {
				return defaultValue;
			} else {
				return result;
			}
		} catch (Exception e) {
			logger.warn(e.getMessage(), e);
			return defaultValue;
		}
	}
}
