package cn.elwy.common.util;

/**
 * 字符串工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class FieldUtil {

	public static final String GET = "get";
	public static final String SET = "set";
	public static final String CLOUMN = "F_";
	public static final String TABLE = "T_";

	private FieldUtil() {
	}

	/**
	 * 去掉字符串两头的空白字符，如果字符串为空，则会被转化为空串
	 * @param content
	 * @return
	 */
	public static String trim(String content) {
		if (content == null) {
			return "";
		}
		int count = content.length(), len = count;
		int st = 0, off = 0;
		char[] val = content.toCharArray();
		while ((st < len) && (Character.isWhitespace(val[off + st]))) {
			st++;
		}
		while ((st < len) && (Character.isWhitespace(val[off + len - 1]))) {
			len--;
		}
		return ((st > 0) || (len < count)) ? content.substring(st, len) : content;
	}

	/**
	 * 判断字符串是否为空
	 * @param content
	 * @return
	 */
	public static boolean isEmpty(String content) {
		return content == null ? true : trim(content).isEmpty();
	}

	/**
	 * 把对象转化成字符串
	 * @param object
	 * @return
	 */
	public static String toString(Object object) {
		return object == null ? "" : trim(object.toString());
	}

	/**
	 * 比较两个字符串
	 */
	public static int compare(String s1, String s2) {
		return trim(s1).compareTo(trim(s2));
	}

	/**
	 * 根据字段名称获取相应的get方法
	 * @param fieldName
	 * @return
	 */
	public static String methodNameByGet(String fieldName) {
		return dbNameToJavaName(GET, fieldName, "_");
	}

	/**
	 * 根据字段名称获取相应的set方法
	 * @param fieldName
	 * @return
	 */
	public static String methodNameBySet(String fieldName) {
		return dbNameToJavaName(SET, fieldName, "_");
	}

	/**
	 * 根据字段名称获取相应的方法
	 * @param prefix
	 * @param fieldName
	 * @return
	 */
	public static String methodName(String prefix, String fieldName) {
		return dbNameToJavaName(prefix, fieldName, "_");
	}

	/**
	 * 根据字段名称获取相应的方法
	 * @param prefix
	 * @param fieldName
	 * @param separate 字段分隔符
	 * @return
	 */
	public static String dbNameToJavaName(String prefix, String fieldName, String separate) {
		String[] str = fieldName.split(separate);
		String methodName = prefix;
		for (String text : str) {
			if (AssertUtil.isEmpty(text)) {
				continue;
			} else if (text.length() == 1) {
				methodName += text.toUpperCase();
			} else if (AssertUtil.isEmpty(methodName)) {
				methodName += text.toLowerCase();
			} else {
				methodName += text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
			}
		}
		return methodName;
	}

	/**
	 * 根据方法名称获取相应的字段，返回全部大写以"_"连接的字符串
	 * @param prefix
	 * @param methodName
	 * @return
	 */
	public static String fieldName(String prefix, String methodName) {
		return javaNameToDbName(prefix, methodName, "_");
	}

	/**
	 * 根据方法名称获取相应的字段，返回全部大写以分隔符连接的字符串
	 * @param prefix
	 * @param javaName java命名方式
	 * @param separate
	 * @return
	 */
	public static String javaNameToDbName(String prefix, String javaName, String separate) {
		if (!AssertUtil.isEmpty(prefix)) {
			int index = javaName.indexOf(prefix);
			if (index == 0) {
				javaName = javaName.substring(index + prefix.length());
			}
		}
		String fieldName = "";
		for (String text : javaName.split("")) {
			if (ValidateUtil.checkMatcher(text, "^[A-Z]+$")) {
				if (!AssertUtil.isEmpty(fieldName)) {
					fieldName += separate;
				}
			}
			fieldName += text.toUpperCase();
		}
		return fieldName;
	}

	public static void main(String[] args) {
		String fieldName = "___Field_Name_String_prefix_String_methodName_String_separate__";
		String fieldName1 = "method_Name_String_prefix_String_methodName_String_separate";
		String result = dbNameToJavaName("get", fieldName, "_");
		System.out.println(result);
		result = methodName("get", fieldName1);
		System.out.println(result);
		result = methodName("", fieldName1);
		System.out.println(result);
		String string = "\r\n dII i   ｉdd d c \t ";
		String trim = trim(string);
		System.out.println(trim);
		String trim2 = string.trim();
		System.out.println(trim2);

		result = javaNameToDbName("get", "getFieldName", "_");
		System.out.println(result);
		result = javaNameToDbName("", "getFieldName", "_");
		System.out.println(result);
		result = javaNameToDbName("", fieldName, "_");
		System.out.println(result);
		result = javaNameToDbName("", fieldName1, "_");
		System.out.println(result);
	}

}
