/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.elwy.common.util;

import java.util.LinkedHashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 执行时间计时器
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class ExecutionTimer {

	private static Logger logger = LoggerFactory.getLogger(ExecutionTimer.class);
	private static ThreadLocal<Map<String, TimerInfo>> timerMap = new ThreadLocal<Map<String, TimerInfo>>() {
		@Override
		protected Map<String, TimerInfo> initialValue() {
			return new LinkedHashMap<String, TimerInfo>();
		}
	};

	static class TimerInfo {
		String description;
		double startTime = 0;
		double elapse = 0;
	}

	private ExecutionTimer() {
	}

	public static boolean start(String id, String description) {
		Map<String, TimerInfo> map = timerMap.get();
		TimerInfo timeType = map.get(id);
		if (null == timeType) {
			timeType = new TimerInfo();
			map.put(id, timeType);
		}
		timeType.description = description;
		timeType.startTime = System.nanoTime();
		return true;
	}

	public static boolean end(String id) {
		TimerInfo timeType = timerMap.get().get(id);
		if (timeType == null) {
			return false;
		}
		timeType.elapse += System.nanoTime() - timeType.startTime;
		printTimerInfo(timeType);
		return true;
	}

	private static void printTimerInfo(TimerInfo timeInfo) {
		StringBuilder msg = new StringBuilder(timeInfo.description);
		msg.append("结束时间：").append(DateUtil.getCurrentTime());
		msg.append(" 用时（s）: ");
		logger.debug(msg.toString());
	}

}
