package cn.elwy.common.util;

/**
 * 枚举类型转换工具
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class EnumUtil {

	/**
	 * 根据枚举类型的name或value值或code值获取枚举类型
	 * @param clazz 枚举类型
	 * @param value
	 * @return
	 */
	public static <E> E getEnum(Class<E> clazz, Object value) {
		E res = getEnumByName(clazz, value);
		if (res == null) {
			res = getEnumByValue(clazz, value);
			if (res == null) {
				res = getEnumByCode(clazz, value);
				if (res == null) {
					res = getEnumByOrdinal(clazz, value);
				}
			}
		}
		return res;
	}

	/**
	 * 根据枚举类型的名称获取枚举类型
	 * @param clazz 枚举类型
	 * @param value
	 * @return
	 */
	public static <E> E getEnumByName(Class<E> clazz, Object value) {
		return getEnumByField(clazz, value, "name");
	}

	/**
	 * 根据枚举类型的code值获取枚举类型
	 * @param clazz 枚举类型
	 * @param value 编码的值
	 * @return
	 */
	public static <E> E getEnumByCode(Class<E> clazz, Object value) {
		return getEnumByField(clazz, value, "code");
	}

	/**
	 * 根据枚举类型的value值获取枚举类型
	 * @param clazz 枚举类型
	 * @param value 编码的值
	 * @return
	 */
	public static <E> E getEnumByValue(Class<E> clazz, Object value) {
		return getEnumByField(clazz, value, "value");
	}

	/**
	 * 根据枚举类型的Ordinal值获取枚举类型
	 * @param clazz 枚举类型
	 * @param value 编码的值
	 * @return
	 */
	public static <E> E getEnumByOrdinal(Class<E> clazz, Object value) {
		return getEnumByMethod(clazz, value, "ordinal");
	}

	/**
	 * 根据枚举类型的字段值获取枚举类型
	 * @param clazz 枚举类型
	 * @param value 编码的值
	 * @param field 字段名称
	 * @return
	 */
	public static <E> E getEnumByField(Class<E> clazz, Object value, String field) {
		if (value == null || value.toString().isEmpty()) {
			return null;
		}
		if (clazz != null && clazz.isEnum()) {
			E[] enums = (E[]) clazz.getEnumConstants();
			for (E e : enums) {
				Object text = ReflectUtil.getFieldValue(e, field);
				if (text != null && value.toString().equals(text.toString())) {
					return e;
				}
			}
		}
		return null;
	}

	/**
	 * 根据枚举类型的方法返回值获取枚举类型
	 * @param clazz 枚举类型
	 * @param value 编码的值
	 * @param method 方法名称
	 * @return
	 */
	public static <E> E getEnumByMethod(Class<E> clazz, Object value, String method) {
		if (clazz != null && clazz.isEnum()) {
			E[] enums = clazz.getEnumConstants();
			for (E e : enums) {
				Object text = ReflectUtil.getMethodValue(e, method);
				if (text != null && value.toString().equals(text.toString())) {
					return e;
				}
			}
		}
		return null;
	}

}