package cn.elwy.common.util;

import java.io.Closeable;
import java.net.HttpURLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

import cn.elwy.common.log.Logger;
import cn.elwy.common.log.LoggerFactory;

/**
 * 关闭资源工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class CloseUtil {

	private static final Logger logger = LoggerFactory.getLogger(CloseUtil.class);

	private CloseUtil() {
	}

	/**
	 * 关闭资源
	 * @param object 要关闭的对象
	 */
	public static void close(JarFile object) {
		try {
			if (object != null) {
				object.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param object 要关闭的对象
	 */
	public static void close(ZipFile object) {
		try {
			if (object != null) {
				object.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param object 要关闭的对象
	 */
	public static void close(Scanner object) {
		try {
			if (object != null) {
				object.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param object 要关闭的对象
	 */
	public static void close(Closeable object) {
		try {
			if (object != null) {
				object.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param objects 要关闭的对象
	 */
	public static void close(Closeable... objects) {
		if (objects != null) {
			for (Closeable closeable : objects) {
				close(closeable);
			}
		}
	}

	/**
	 * 关闭资源
	 * @param conn 要关闭的对象
	 */
	public static void close(Connection conn) {
		try {
			if (conn != null) {
				conn.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param object 要关闭的对象
	 */
	public static void close(Statement statement) {
		try {
			if (statement != null) {
				statement.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param resultSet 要关闭的对象
	 */
	public static void close(ResultSet resultSet) {
		try {
			if (resultSet != null) {
				resultSet.close();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 关闭资源
	 * @param resultSet
	 * @param statement
	 * @param conn
	 */
	public static void close(ResultSet resultSet, Statement statement) {
		try {
			close(resultSet);
		} finally {
			close(statement);
		}
	}

	/**
	 * 关闭资源
	 * @param conn 要关闭的对象
	 */
	public static void close(HttpURLConnection conn) {
		try {
			if (conn != null) {
				close(conn.getInputStream());
				close(conn.getErrorStream());
				conn.disconnect();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	/**
	 * 释放资源
	 * @param object 要释放的对象
	 * @param methodName 调用方法
	 */
	public static void dispose(Object object, String methodName) {
		try {
			ReflectUtil.invoke(object, methodName);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

}
