package cn.elwy.common.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@SuppressWarnings("unchecked")
public final class ClassUtil {

	private ClassUtil() {
	}

	/**
	 * 获取接口的泛型类型，如果不存在则返回null
	 * @param <T>
	 * @param clazz
	 * @return
	 */
	public static <T> Class<T> getGenericClass(Class<?> clazz) {
		Type t = clazz.getGenericSuperclass();
		if (t instanceof ParameterizedType) {
			Type[] p = ((ParameterizedType) t).getActualTypeArguments();
			return (Class<T>) p[0];
		}
		return null;
	}

	public static StackTraceElement getCurrentStackTraceElement() {
		return Thread.currentThread().getStackTrace()[2];
	}

	public static String getCurrentMethodName() {
		StackTraceElement stackTraceElement = getCurrentStackTraceElement();
		return stackTraceElement.getMethodName();
	}

}
