package cn.elwy.common.util;

import java.util.Collection;
import java.util.Map;

/**
 * Java对象比较、空判断等工具
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class AssertUtil {

	private AssertUtil() {
	}

	public static boolean isBlank(String str) {
		int strLen;
		if (str == null || (strLen = str.length()) == 0) {
			return true;
		}
		for (int i = 0; i < strLen; i++) {
			if ((Character.isWhitespace(str.charAt(i)) == false)) {
				return false;
			}
		}
		return true;
	}

	public static boolean isNotBlank(String str) {
		return !isBlank(str);
	}

	public static boolean isEmpty(Collection<?> collection) {
		return isNull(collection) || collection.size() < 1;
	}

	public static boolean isEmpty(Map<?, ?> map) {
		return isNull(map) || map.size() < 1;
	}

	public static boolean isEmpty(Object object) {
		if (object instanceof Collection) {
			return isEmpty((Collection<?>) object);
		} else if (object instanceof Map) {
			return isEmpty((Map<?, ?>) object);
		}
		return isNull(object) || "".equals(object);
	}

	public static boolean isEmpty(Object[] object) {
		return isNull(object) || object.length < 1;
	}

	public static boolean isEmpty(String text) {
		return isNull(text) || text.length() < 1;
	}

	public static boolean isNotEmpty(Collection<?> collection) {
		return !isEmpty(collection);
	}

	public static boolean isNotEmpty(Map<?, ?> map) {
		return !isEmpty(map);
	}

	public static boolean isNotEmpty(Object object) {
		return !isEmpty(object);
	}

	public static boolean isNotEmpty(Object[] object) {
		return !isEmpty(object);
	}

	public static boolean isNotEmpty(String text) {
		return !isEmpty(text);
	}

	public static boolean isNull(Object object) {
		return object == null;
	}

	public static boolean isNotNull(Object object) {
		return object != null;
	}

	public static boolean isContain(String textToSearch, String substring) {
		if (isNotEmpty(textToSearch) && isNotEmpty(substring) && textToSearch.contains(substring)) {
			return true;
		} else {
			return false;
		}
	}

	public static boolean isAssignable(Class<?> superType, Class<?> subType) {
		if (isNotNull(superType) && isNotNull(subType) && superType.isAssignableFrom(subType)) {
			return true;
		} else {
			return false;
		}
	}

	public static boolean isInstanceOf(Class<?> type, Object object) {
		if (isNotNull(type) && type.isInstance(object)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 判断字符串的内容是不是全是数字
	 * @param text
	 * @return
	 */
	public static boolean isNumeric(String text) {
		if (isEmpty(text)) {
			return false;
		}
		int size = text.length();
		for (int i = 0; i < size; i++) {
			if (!Character.isDigit(text.charAt(i))) {
				return false;
			}
		}
		return true;
	}

	/**
	 * 比较两个路径是否相同
	 * @param path1
	 * @param path2
	 * @return
	 */
	public static boolean equalsPath(String path1, String path2) {
		boolean empty1 = AssertUtil.isBlank(path1);
		boolean empty2 = AssertUtil.isBlank(path2);
		if (empty1 || empty2) {
			if (path1.equals(path2)) {
				return true;
			} else {
				return false;
			}
		} else {
			path1 = path1.replace("\\", "/");
			path2 = path2.replace("\\", "/");
			return path1.equalsIgnoreCase(path2);
		}
	}

	public static boolean equals(Object o1, Object o2) {
		return o1 == null ? o2 == null : o1.equals(o2);
	}

	public static boolean notEquals(Object o1, Object o2) {
		return !equals(o1, o2);
	}

	public static boolean equalsIgnoreCase(Object o1, Object o2) {
		return o1 == null ? o2 == null : (o2 == null ? false : o1.toString().equalsIgnoreCase(o2.toString()));
	}

	public static boolean notEqualsIgnoreCase(Object o1, Object o2) {
		return !equalsIgnoreCase(o1, o2);
	}

	/**
	 * 是否中文乱码
	 * @param text
	 * @return
	 */
	protected static boolean isMessyCode(String text) {
		return !java.nio.charset.Charset.forName("GBK").newEncoder().canEncode(text);
	}
}
