package cn.elwy.common.util;

import java.lang.reflect.Array;

/**
 * 数组操作工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public final class ArrayUtil {

	private ArrayUtil() {
	}

	public static Object[] addAll(Object[] array1, Object[] array2) {
		if (array1 == null) {
			return clone(array2);
		} else if (array2 == null) {
			return clone(array1);
		}
		Object[] joinedArray = (Object[]) Array.newInstance(array1.getClass().getComponentType(),
				array1.length + array2.length);
		System.arraycopy(array1, 0, joinedArray, 0, array1.length);
		try {
			System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
		} catch (ArrayStoreException ase) {
			// Check if problem was due to incompatible types
			/*
			 * We do this here, rather than before the copy because: - it would be a wasted check most of the time - safer, in
			 * case check turns out to be too strict
			 */
			final Class<?> type1 = array1.getClass().getComponentType();
			final Class<?> type2 = array2.getClass().getComponentType();
			if (!type1.isAssignableFrom(type2)) {
				throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName());
			}
			throw ase; // No, so rethrow original
		}
		return joinedArray;
	}

	public static Object[] clone(Object[] array) {
		if (array == null) {
			return null;
		}
		return (Object[]) array.clone();
	}

}
