package cn.elwy.common.log;

import org.slf4j.Logger;
import org.slf4j.Marker;

import cn.elwy.common.exception.ExceptionSupport;
import cn.elwy.common.exception.MsgLevel;
import cn.elwy.common.i18n.Msg;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class LoggerImpl implements cn.elwy.common.log.Logger, Logger {

	private String name;
	private volatile Logger logger;

	public LoggerImpl(String name) {
		this.name = name;
	}

	public LoggerImpl(Logger logger) {
		this.logger = logger;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setLogger(Logger logger) {
		this.logger = logger;
	}

	public Logger getLogger() {
		if (logger == null && LogConfig.isInit()) {
			synchronized (LoggerImpl.class) {
				if (logger == null && LogConfig.isInit()) {
					if (name == null) {
						logger = org.slf4j.LoggerFactory.getLogger(getClass());
					} else {
						logger = org.slf4j.LoggerFactory.getLogger(name);
					}
				}
			}
		}
		return logger;
	}

	public String getName() {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.getName();
		}
		return "";
	}

	public boolean isTraceEnabled() {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isTraceEnabled();
		}
		return LogConfig.isTraceEnabled();
	}

	public void trace(String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(msg);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, (Object[]) null);
	}

	public void trace(String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(msg, arg);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, arg);
	}

	public void trace(String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, arg1, arg2);
	}

	public void trace(String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(msg, args);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, args);
	}

	public void trace(String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(msg, e);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, e, (Object[]) null);
	}

	public boolean isTraceEnabled(Marker marker) {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isTraceEnabled(marker);
		}
		return LogConfig.isTraceEnabled();
	}

	public void trace(Marker marker, String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(marker, msg);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, (Object[]) null);
	}

	public void trace(Marker marker, String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(marker, msg, arg);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, arg);
	}

	public void trace(Marker marker, String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(marker, msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, arg1, arg2);
	}

	public void trace(Marker marker, String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(marker, msg, args);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, null, args);
	}

	public void trace(Marker marker, String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.trace(marker, msg, e);
		}
		outputMsg(logger == null, MsgLevel.TRACE, msg, e, (Object[]) null);
	}

	public boolean isDebugEnabled() {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isDebugEnabled();
		}
		return LogConfig.isDebugEnabled();
	}

	public boolean isEnabled(MsgLevel level) {
		switch (level) {
		case DEBUG:
			return isDebugEnabled();
		case INFO:
			return isInfoEnabled();
		case WARN:
			return isWarnEnabled();
		case ERROR:
			return isErrorEnabled();
		case TRACE:
			return isTraceEnabled();
		default:
			return true;
		}
	}

	public void debug(String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(msg);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, (Object[]) null);
	}

	public void debug(String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(msg, arg);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, arg);
	}

	public void debug(String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, arg1, arg2);
	}

	public void debug(String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(msg, args);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, args);
	}

	public void debug(String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(msg, e);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, e, (Object[]) null);
	}

	public boolean isDebugEnabled(Marker marker) {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isDebugEnabled(marker);
		}
		return LogConfig.isDebugEnabled();
	}

	public void debug(Marker marker, String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(marker, msg);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, (Object[]) null);
	}

	public void debug(Marker marker, String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(marker, msg, arg);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, arg);
	}

	public void debug(Marker marker, String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(marker, msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, arg1, arg2);
	}

	public void debug(Marker marker, String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(marker, msg, args);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, null, args);
	}

	public void debug(Marker marker, String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.debug(marker, msg, e);
		}
		outputMsg(logger == null, MsgLevel.DEBUG, msg, e, (Object[]) null);
	}

	public boolean isInfoEnabled() {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isInfoEnabled();
		} else {
			return LogConfig.isInfoEnabled();
		}
	}

	public void info(String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(msg);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, (Object[]) null);
	}

	public void info(String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(msg, arg);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, arg);
	}

	public void info(String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, arg1, arg2);
	}

	public void info(String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(msg, args);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, args);
	}

	public void info(String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(msg, e);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, e, (Object[]) null);
	}

	public boolean isInfoEnabled(Marker marker) {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isInfoEnabled(marker);
		} else {
			return LogConfig.isInfoEnabled();
		}
	}

	public void info(Marker marker, String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(marker, msg);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, (Object[]) null);
	}

	public void info(Marker marker, String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(marker, msg, arg);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, arg);
	}

	public void info(Marker marker, String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(marker, msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, arg1, arg2);
	}

	public void info(Marker marker, String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(marker, msg, args);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, null, args);
	}

	public void info(Marker marker, String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.info(marker, msg, e);
		}
		outputMsg(logger == null, MsgLevel.INFO, msg, e, (Object[]) null);
	}

	public boolean isWarnEnabled() {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isWarnEnabled();
		}
		return LogConfig.isWarnEnabled();
	}

	public void warn(String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(msg);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, (Object[]) null);
	}

	public void warn(String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(msg, arg);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, arg);
	}

	public void warn(String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(msg, args);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, args);
	}

	public void warn(String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, arg1, arg2);
	}

	public void warn(String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(msg, e);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, e, (Object[]) null);
	}

	public boolean isWarnEnabled(Marker marker) {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isWarnEnabled(marker);
		}
		return LogConfig.isWarnEnabled();
	}

	public void warn(Marker marker, String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(marker, msg);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, (Object[]) null);
	}

	public void warn(Marker marker, String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(marker, msg, arg);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, arg);
	}

	public void warn(Marker marker, String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(marker, msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, arg1, arg2);
	}

	public void warn(Marker marker, String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(marker, msg, args);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, null, args);
	}

	public void warn(Marker marker, String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.warn(marker, msg, e);
		}
		outputMsg(logger == null, MsgLevel.WARN, msg, e, (Object[]) null);
	}

	public boolean isErrorEnabled() {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isErrorEnabled();
		}
		return LogConfig.isErrorEnabled();
	}

	public void error(String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(msg);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, (Object[]) null);
	}

	public void error(String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(msg, arg);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, arg);
	}

	public void error(String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, arg1, arg2);
	}

	public void error(String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(msg, args);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, args);
	}

	public void error(String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(msg, e);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, e, (Object[]) null);
	}

	public boolean isErrorEnabled(Marker marker) {
		Logger logger = getLogger();
		if (logger != null) {
			return logger.isErrorEnabled(marker);
		}
		return LogConfig.isErrorEnabled();
	}

	public void error(Marker marker, String msg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(marker, msg);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, (Object[]) null);
	}

	public void error(Marker marker, String msg, Object arg) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(marker, msg, arg);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, arg);
	}

	public void error(Marker marker, String msg, Object arg1, Object arg2) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(marker, msg, arg1, arg2);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, arg1, arg2);
	}

	public void error(Marker marker, String msg, Object... args) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(marker, msg, args);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, null, args);
	}

	public void error(Marker marker, String msg, Throwable e) {
		Logger logger = getLogger();
		if (logger != null) {
			logger.error(marker, msg, e);
		}
		outputMsg(logger == null, MsgLevel.ERROR, msg, e, (Object[]) null);
	}

	public void log(String msg, Object... args) {
		log(null, msg, null, args);
	}

	public void log(MsgLevel level, String msg, Object... args) {
		log(level, msg, null, args);
	}

	public void log(String msg, Throwable e, Object... args) {
		log(null, msg, e, args);
	}

	public void log(MsgLevel level, String msg, Throwable e, Object... args) {
		if (level == null) {
			if (e != null) {
				level = MsgLevel.ERROR;
			} else {
				level = MsgLevel.INFO;
			}
			return;
		}
		switch (level) {
		case DEBUG:
			if (args != null) {
				if (e != null) {
					debug(msg, e, args);
				} else {
					debug(msg, args);
				}
			} else {
				if (e != null) {
					debug(msg, e);
				} else {
					debug(msg);
				}
			}
			break;
		case INFO:
			if (args != null) {
				if (e != null) {
					info(msg, e, args);
				} else {
					info(msg, args);
				}
			} else {
				if (e != null) {
					info(msg, e);
				} else {
					info(msg);
				}
			}
			break;
		case WARN:
			if (args != null) {
				if (e != null) {
					warn(msg, e, args);
				} else {
					warn(msg, args);
				}
			} else {
				if (e != null) {
					warn(msg, e);
				} else {
					warn(msg);
				}
			}
			break;
		case ERROR:
			if (args != null) {
				if (e != null) {
					error(msg, e, args);
				} else {
					error(msg, args);
				}
			} else {
				if (e != null) {
					error(msg, e);
				} else {
					error(msg);
				}
			}
			break;
		case TRACE:
			if (args != null) {
				if (e != null) {
					trace(msg, e, args);
				} else {
					trace(msg, args);
				}
			} else {
				if (e != null) {
					trace(msg, e);
				} else {
					trace(msg);
				}
			}
			break;
		default:
			Logger logger = getLogger();
			if (logger != null) {
				if (args != null) {
					if (e != null) {
						logger.info(msg, e, args);
					} else {
						logger.info(msg, args);
					}
				} else {
					if (e != null) {
						logger.info(msg, e);
					} else {
						logger.info(msg);
					}
				}
			}
			outputMsg(logger == null, level, msg, e, args);
			break;
		}
	}

	protected void outputMsg(boolean isOutput, MsgLevel level, String msg, Throwable e, Object... args) {
		if (!isOutput(isOutput) || !isEnabled(level)) {
			return;
		}
		if (args != null) {
			msg = Msg.format(msg, args);
		}
		String detailMessage = "";
		if (e != null) {
			detailMessage = ExceptionSupport.getDetailMessage(e);
			msg = msg + "\r\n" + detailMessage;
		}
		switch (level) {
		case ERROR:
		case TRACE:
			System.err.println(msg);
			break;
		case DEBUG:
		case INFO:
		case WARN:
			System.out.println(msg);
			break;
		default:
			System.out.println("MsgLevel is default, Msg:" + msg);
			break;
		}
	}

	protected boolean isOutput(boolean isOutput) {
		return isOutput;
	}
}
