package cn.elwy.common.jdbc.callback;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.elwy.common.jdbc.CurrentConnection;
import cn.elwy.common.util.AssertUtil;
import cn.elwy.common.util.CloseUtil;

/**
 * 对ResultSet进行处理
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class ResultData {

	private CurrentConnection conn;
	private PreparedStatement pstmt;
	private ResultSet resultSet;

	public ResultData(CurrentConnection conn, PreparedStatement pstmt, ResultSet rs) {
		this.conn = conn;
		this.pstmt = pstmt;
		this.resultSet = rs;
	}

	public ResultSet getResultSet() {
		return resultSet;
	}

	public void setResultSet(ResultSet rs) {
		this.resultSet = rs;
	}

	@SuppressWarnings("unchecked")
	public <E> E getData(String column) throws SQLException {
		if (AssertUtil.isNotEmpty(resultSet)) {
			return (E) resultSet.getObject(column);
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	public <E> E getData(int columnIndex) throws SQLException {
		if (AssertUtil.isNotEmpty(resultSet)) {
			return (E) resultSet.getObject(columnIndex);
		}
		return null;
	}

	/**
	 * 释放资源
	 */
	public void destory() {
		CloseUtil.close(resultSet, pstmt);
		if (AssertUtil.isNotNull(conn)) {
			conn.close();
		}
	}

}
