package cn.elwy.common.jdbc.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据库表标记
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DbTable {

	/**
	 * 表名
	 * @return
	 */
	String value();

	/**
	 * 回收站名
	 * @return
	 */
	boolean hasRecycle() default true;

}