package cn.elwy.common.jdbc.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据库表ID字段标记
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface DbId {

	enum IdPattern {
		AUTO_INCREMENT, UUID, NEXTID, SEQUENCE;
	}

	/**
	 * ID取值方式
	 * @return
	 */
	IdPattern type() default IdPattern.SEQUENCE;

}