package cn.elwy.common.jdbc.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据库表字段标记
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface DbColumn {

	/**
	 * 字段名称
	 * @return
	 */
	String value();

	/**
	 * 字段的类型
	 * @return
	 */
	Class<?> type() default String.class;

	/**
	 * 字段的长度
	 * @return
	 */
	int length() default 0;

}