package cn.elwy.common.jdbc;

import java.sql.Connection;
import java.util.LinkedList;

/**
 * 根据配置创建数据库连接
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class SingleDataSource extends MyDataSource {

	protected final LinkedList<Connection> connPool = new LinkedList<Connection>();

	private boolean isNewConnect = true; // 是否得到一个新的连接,只对单连接有效

	public SingleDataSource() {
	}

	public SingleDataSource(DBInfo dbInfo) {
		super(dbInfo);
	}

	public SingleDataSource(String driver, String url, String user, String password) {
		super(driver, url, user, password);
	}

	/** 获得一个可用的数据库连接 */
	public synchronized Connection getConnection() {
		if (!isNewConnect) {
			for (int i = connPool.size(); i > 0; i--) {
				Connection conn = connPool.removeFirst();
				if (isConnected(conn)) {
					connPool.addLast(conn);
					return conn;
				} else {
					close(conn);
				}
			}
		}
		// 每次得到一个新的连接
		Connection conn = createConn();
		connPool.addLast(conn);
		return conn;
	}

	/** 测试数据库连接是否可用 */
	public boolean ping() {
		try {
			return isConnected(getConnection());
		} catch (Exception e) {
			return false;
		}
	}

	/** 关闭conn */
	public void close() {
		for (int i = connPool.size(); i > 0; i--) {
			closeConn(connPool.removeFirst());
		}
	}

	public boolean isNewConnect() {
		return isNewConnect;
	}

	public void setNewConnect(boolean isNewConnect) {
		this.isNewConnect = isNewConnect;
	}

}
