package cn.elwy.common.jdbc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;

import cn.elwy.common.Constant;
import cn.elwy.common.util.CloseUtil;
import cn.elwy.common.util.io.FileUtil;

/**
 * 根据一组SQL语句生成SQL文件
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class GenerateSQLFile {

	/** SQL语句命令分隔符 */
	private String delimiter = ";";
	/** 文件编码 */
	private String encoding = "UTF-8";
	/** 每条SQL语句后面添加换行符 */
	private boolean addLineSeparator;

	/**
	 * 根据一组SQL语句生成SQL文件构造函数
	 * @param addLineSeparator 是否在每条SQL语句后面添加换行符
	 */
	public GenerateSQLFile(boolean addLineSeparator) {
		this.addLineSeparator = addLineSeparator;
	}

	/**
	 * 保存SQL语句到指定的文件
	 * @param outFile 输出文件
	 * @param sqlList sql语句列表
	 * @throws IOException
	 */
	public void generateSQLFile(File outFile, List<String> sqlList) throws IOException {
		BufferedWriter bufferedWriter = FileUtil.getBufferedWriter(outFile, encoding);
		try {
			String lineSeparator = Constant.LINE_SEPARATOR;
			for (String sql : sqlList) {
				if (!sql.equals(lineSeparator)) {
					sql = sql + delimiter;
				}
				if (addLineSeparator) {
					sql = sql + lineSeparator;
				}
				FileUtil.writeBufferedWriter(bufferedWriter, sql);
			}
		} finally {
			CloseUtil.close(bufferedWriter);
		}
	}

	/**
	 * @return the delimiter
	 */
	public String getDelimiter() {
		return delimiter;
	}

	/**
	 * @param delimiter the delimiter to set
	 */
	public void setDelimiter(String delimiter) {
		this.delimiter = delimiter;
	}

	/**
	 * @return the encoding
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * @param encoding the encoding to set
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	/**
	 * @return the addLineSeparator
	 */
	public boolean isAddLineSeparator() {
		return addLineSeparator;
	}

	/**
	 * @param addLineSeparator the addLineSeparator to set
	 */
	public void setAddLineSeparator(boolean addLineSeparator) {
		this.addLineSeparator = addLineSeparator;
	}

}
