package cn.elwy.common.jdbc;

import java.io.Serializable;
import java.util.List;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class DSTemplate implements Serializable {

	private static final long serialVersionUID = 1L;

	private String id;
	private int index; // 数据库端口
	private boolean disable;

	private String dbType; // 数据库类型
	private String displayName; // 显示名称
	/** 驱动描述 */
	private String description;
	private List<DSDriver> driverList;
	private String host; // 数据库主机
	private int port; // 数据库端口
	private String name; // 数据库实例名称
	private String parameter; // 数据库实例名称

	private int minPoolSize;
	private int maxPoolSize;
	private int maxIdleTime;
	private int acquisitionTimeout;
	private boolean isShareTransactionConnections;
	private int acquireIncrement;
	private boolean isDeferConnectionRelease;
	private String testQuery;

	public DSTemplate() {
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * @param index the index to set
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * @return the disable
	 */
	public boolean isDisable() {
		return disable;
	}

	/**
	 * @param disable the disable to set
	 */
	public void setDisable(boolean disable) {
		this.disable = disable;
	}

	/**
	 * @return the dbType
	 */
	public String getDbType() {
		return dbType;
	}

	/**
	 * @param dbType the dbType to set
	 */
	public void setDbType(String dbType) {
		this.dbType = dbType;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the displayName to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the driverList
	 */
	public List<DSDriver> getDriverList() {
		return driverList;
	}

	/**
	 * @param driverList the driverList to set
	 */
	public void setDriverList(List<DSDriver> driverList) {
		this.driverList = driverList;
	}

	/**
	 * @return the host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host the host to set
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return the port
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @param port the port to set
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the parameter
	 */
	public String getParameter() {
		return parameter;
	}

	/**
	 * @param parameter the parameter to set
	 */
	public void setParameter(String parameter) {
		this.parameter = parameter;
	}

	/**
	 * @return the minPoolSize
	 */
	public int getMinPoolSize() {
		return minPoolSize;
	}

	/**
	 * @param minPoolSize the minPoolSize to set
	 */
	public void setMinPoolSize(int minPoolSize) {
		this.minPoolSize = minPoolSize;
	}

	/**
	 * @return the maxPoolSize
	 */
	public int getMaxPoolSize() {
		return maxPoolSize;
	}

	/**
	 * @param maxPoolSize the maxPoolSize to set
	 */
	public void setMaxPoolSize(int maxPoolSize) {
		this.maxPoolSize = maxPoolSize;
	}

	/**
	 * @return the maxIdleTime
	 */
	public int getMaxIdleTime() {
		return maxIdleTime;
	}

	/**
	 * @param maxIdleTime the maxIdleTime to set
	 */
	public void setMaxIdleTime(int maxIdleTime) {
		this.maxIdleTime = maxIdleTime;
	}

	/**
	 * @return the acquisitionTimeout
	 */
	public int getAcquisitionTimeout() {
		return acquisitionTimeout;
	}

	/**
	 * @param acquisitionTimeout the acquisitionTimeout to set
	 */
	public void setAcquisitionTimeout(int acquisitionTimeout) {
		this.acquisitionTimeout = acquisitionTimeout;
	}

	/**
	 * @return the isShareTransactionConnections
	 */
	public boolean isShareTransactionConnections() {
		return isShareTransactionConnections;
	}

	/**
	 * @param isShareTransactionConnections the isShareTransactionConnections to set
	 */
	public void setShareTransactionConnections(boolean isShareTransactionConnections) {
		this.isShareTransactionConnections = isShareTransactionConnections;
	}

	/**
	 * @return the acquireIncrement
	 */
	public int getAcquireIncrement() {
		return acquireIncrement;
	}

	/**
	 * @param acquireIncrement the acquireIncrement to set
	 */
	public void setAcquireIncrement(int acquireIncrement) {
		this.acquireIncrement = acquireIncrement;
	}

	/**
	 * @return the isDeferConnectionRelease
	 */
	public boolean isDeferConnectionRelease() {
		return isDeferConnectionRelease;
	}

	/**
	 * @param isDeferConnectionRelease the isDeferConnectionRelease to set
	 */
	public void setDeferConnectionRelease(boolean isDeferConnectionRelease) {
		this.isDeferConnectionRelease = isDeferConnectionRelease;
	}

	/**
	 * @return the testQuery
	 */
	public String getTestQuery() {
		return testQuery;
	}

	/**
	 * @param testQuery the testQuery to set
	 */
	public void setTestQuery(String testQuery) {
		this.testQuery = testQuery;
	}

}
