package cn.elwy.common.jdbc;

/**
 * 数据库类型枚举类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public enum DBType {

	MYSQL, ORACLE, SQLITE, DB2, MSSQL, MSSQL2000, MSSQL2005, HSQLDB, ACCESS, INFORMIX, POSTGRESQL, SYBASE, DB4O;

	public static DBType getEnumType(String type) {
		return valueOf(type.toUpperCase());
	}

	public static int toEnumIndex(String type) {
		return getEnumType(type).ordinal();
	}

	public static void main(String[] args) {
		System.out.println(DBType.getEnumType("MYSQL"));
		System.out.println(DBType.toEnumIndex("Mysql"));
		System.out.println(DBType.toEnumIndex("ACCESS"));
		System.out.println(DBType.ACCESS);
	}

}