package cn.elwy.common.id;

import java.util.concurrent.ArrayBlockingQueue;

/**
 * 基于时间戳的自定义ID生成器实现类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class BaseIdGenerator implements IdGenerator {

	protected int casheSize = 0;
	protected ArrayBlockingQueue<String> cacheQueue;

	public BaseIdGenerator() {
		this(0);
	}

	public BaseIdGenerator(int casheSize) {
		this.casheSize = casheSize;
		if (casheSize > 0) {
			this.cacheQueue = new ArrayBlockingQueue<String>(casheSize);
			this.batchCache();
		}
	}

	/**
	 * 由当前时间(7-10位) + 本地IP的3位随机数 + 9位10进制组成，其中时间、ip随机数、9位10进制中的前5位采用62进制进行编码；<br />
	 * 后4位采用10进制，用于分库，最多可拆分8192个数据库；ID总长度不超过20位。不同服务器每毫秒支持9亿次并发，理论上唯一。
	 * @return
	 */
	public String nextId() {
		if (this.casheSize == 0) {
			return this.generate(0);
		}

		while (true) {
			String id = this.cacheQueue.poll();
			if (id != null) {
				return id;
			}
			this.batchCache();
		}
	}

	protected String generate(int order) {
		return IdUtil.nextId();
	}

	/**
	 * 批量生成id
	 */
	protected synchronized void batchCache() {
		cacheQueue.clear();
		for (int i = 0; i < this.casheSize; i++) {
			String id = generate(i);
			if (!cacheQueue.offer(id)) {
				break;
			}
		}
	}

}
