package cn.elwy.common.i18n;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * 常用国际化信息类,信息按首字母分类 E:错误信息,F:需要格式化的信息,T:文本信息,M:提示信息,
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class Msg extends NLS {

	private static Class<? extends Msg> clazz = Msg.class;
	private static String BUNDLE_NAME = Msg.class.getName();
	protected final static Map<Class<? extends Msg>, Map<String, String>> msgMaps = new HashMap<Class<? extends Msg>, Map<String, String>>();

	public static String M_TITLE;
	public static String M_CONTENT;
	public static String M_OK;
	public static String M_CANCEL;
	public static String M_BACK;
	public static String M_NEXT;
	public static String M_FINISH;
	public static String M_CLOSE;
	public static String M_SAVE;
	public static String M_EXIT;
	public static String M_ADD;
	public static String M_DEL;
	public static String M_MODIFY;
	public static String M_QUERY;
	public static String M_UP;
	public static String M_DOWN;
	public static String M_NEW;
	public static String M_SUCCESS;
	public static String M_FAILING;
	public static String M_CONFIRM;
	public static String M_ERROR;
	public static String M_INFORMATION;
	public static String M_WARNING;
	public static String M_QUESTION;
	public static String M_OPERATE_SUCCESS;
	public static String M_OPERATE_FAILING;
	public static String M_SYSTEM_INFORMATION;
	public static String M_USER;
	public static String M_USERNAME;
	public static String M_PASSWORD;

	public static String F_ADD_OPERATION;
	public static String F_SELECT_OPERATION;
	public static String F_UPDATE_OPERATION;
	public static String F_DELETE_OPERATION;
	public static String F_REQUIRE;
	public static String F_ILLEGAL;
	public static String F_CLOSE_OBJECT;
	public static String F_OBJECT_EXISTS;
	public static String F_SET_PROPERTY;

	public static String E_IS_NULL;
	public static String E_LOAD_CONFIG_ERROR;
	public static String E_SAVE_CONFIG_ERROR;
	public static String E_FILE_NOT_EXISTS;
	public static String E_INIT_CONFIG_ERROR;
	public static String E_THREAD_END;
	public static String E_INPUT_ARGS;
	public static String F_FORMAT;
	public static String E_URL_CONNECT;
	public static String E_PATH_INVALID;
	public static String E_READ_CNOFIG;
	public static String E_WRITE_CNOFIG;

	public static String E_CONN_INIT;
	public static String E_CONN_POOL;
	public static String E_CONN_CURRENT_COUNT;
	public static String E_CONN_CREAT_POOL;
	public static String E_SET_AUTO_COMMIT;
	public static String E_COMMIT;
	public static String E_ROLLBACK;
	public static String E_DAO_SELECT;
	public static String E_DAO_INSERT;
	public static String E_DAO_UPDATE;
	public static String E_DAO_DELETE;

	public static String E_CONN_DRIVER;
	public static String E_CONN_CREATE;
	public static String E_CONN_DISABLE;
	public static String E_CONN_EXECUTE;
	public static String E_CONN_QUERY;
	public static String E_CONN_UPDATE;
	public static String E_CONN_AUTO_COMMIT;
	public static String E_CONN_COMMIT;
	public static String E_CONN_ROLLBACK;
	public static String E_CONN_CLOSE;
	public static String E_CONN_GET_MAX_POOL;
	public static String E_CONN_NOT_EXIST;
	public static String E_CONN_REFRESH;
	public static String M_CONN_CLEAR;
	public static String E_INIT_SQL_ARGS;
	public static String E_CONN_GET;
	public static String E_CONN_BUSY;
	// public static String F_CONN_POOL;
	// public static String F_CONN_CREAT_POOL;
	// public static String F_CONN_CURRENT_COUNT;

	public static String E_ZIPUTIL_UNZIPPATHCANNOTFILE;

	static {
		// msgMaps.put(Msg.class.getName(), NLS.initializeMessages(BUNDLE_NAME,
		// Msg.class));
		msgMaps.put(clazz, NLS.initializeMessages(BUNDLE_NAME, clazz));
	}

	protected Msg() {
	}

	/**
	 * 获取所以的国际化信息
	 * @return
	 */
	public static Map<Class<? extends Msg>, Map<String, String>> getMsgMaps() {
		return msgMaps;
	}

	/**
	 * 根据国际化类获取对应的信息列表
	 * @param prefix
	 * @return
	 */
	public static Map<String, String> getMsgMap(Class<? extends Msg> clazz) {
		Map<String, String> map = getMsgMaps().get(clazz);
		return map;
	}

	/**
	 * 根据国际化类和属性前缀获取对应的信息列表
	 * @param clazz
	 * @param prefix
	 * @return
	 */
	public static Map<String, String> getMsgMap(Class<? extends Msg> clazz, String prefix) {
		Set<Entry<String, String>> entrySet = getMsgMap(clazz).entrySet();
		Map<String, String> subMap = new HashMap<String, String>();
		for (Entry<String, String> entry : entrySet) {
			String key = entry.getKey();
			if (key.startsWith(prefix)) {
				subMap.put(key, entry.getValue());
			}
		}
		return subMap;
	}

}
