package cn.elwy.common.exception;

/**
 * 运行时异常的顶级基类,用户自定义运行时异常继承此类.
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class RunException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/** 异常信息 */
	protected String message;
	/** 错误编码 */
	protected String errorCode;
	/** 异常级别 */
	protected MsgLevel msgLevel;

	/**
	 * 自定义运行时异常
	 * @param message 异常信息
	 */
	public RunException(String message) {
		super(message);
		this.message = message;
		init();
	}

	/**
	 * 自定义运行时异常
	 * @param cause 异常原因
	 */
	public RunException(Throwable cause) {
		super(cause);
		init();
	}

	/**
	 * 自定义运行时异常
	 * @param message 异常信息
	 * @param cause 异常原因
	 */
	public RunException(String message, Throwable cause) {
		super(message, cause);
		this.message = message;
		init();
	}

	/**
	 * 自定义运行时异常
	 * @param message 异常信息
	 * @param detailMsg 异常详细信息
	 */
	public RunException(String message, String detailMsg) {
		super(message, new Throwable(detailMsg));
		this.message = message;
		init();
	}

	/**
	 * 缺省设置
	 */
	protected void init() {
	}

	/**
	 * 获取异常详细的堆栈信息
	 * @return 详细信息
	 */
	public String getDetailMessage() {
		return ExceptionSupport.getDetailMessage(getCause(), message);
	}

	/**
	 * 获取错误编码
	 * @return 错误码
	 */
	public String getErrorCode() {
		return errorCode;
	}

	/**
	 * 设置异常错误编码
	 * @param errorCode 错误码
	 */
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	/**
	 * 获取异常的级别
	 * @return 消息级别
	 */
	public MsgLevel getMsgLevel() {
		return msgLevel;
	}

	/**
	 * 设置异常的级别，可选值：NONE, ERROR, INFO, WARN, QUESTION, SUCCESS
	 * @param msgLevel 异常级别
	 */
	public void setMsgLevel(MsgLevel msgLevel) {
		this.msgLevel = msgLevel;
	}

}
