package cn.elwy.common.exception;

/**
 * 自定义消息级别枚举类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public enum MsgLevel {

	NONE(0), DEBUG(1), ERROR(2), INFO(3), WARN(4), TRACE(4), SUCCESS(8), CONFIRM(5), QUESTION(6), QUESTION_WITH_CANCEL(7);

	private int id;

	private MsgLevel(int id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	/**
	 * 根据字符串获取消息级别枚举类型
	 * @param msgLevel 消息级别
	 * @return
	 */
	public static MsgLevel getEnumType(String msgLevel) {
		return valueOf(msgLevel.toUpperCase());
	}

	/**
	 * 根据字符串获取消息级别对应的序号
	 * @param msgLevel 消息级别
	 * @return
	 */
	public static int toEnumIndex(String msgLevel) {
		return getEnumType(msgLevel).ordinal();
	}

}