package cn.elwy.common.exception;

import java.io.PrintWriter;
import java.io.StringWriter;

import cn.elwy.common.util.CloseUtil;

/**
 * 获取异常详细信息工具类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class ExceptionSupport {

	/**
	 * 获取异常详细的堆栈信息
	 * @return 详细信息
	 */
	public static String getDetailMessage(Throwable e) {
		return getDetailMessage(e, null);
	}

	/**
	 * 获取异常详细的堆栈信息
	 * @param e 异常
	 * @param message 缺省信息
	 * @return 详细信息
	 */
	public static String getDetailMessage(Throwable e, String message) {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		try {
			if (e != null) {
				e.printStackTrace(pw);
			} else if (message != null) {
				sw.write(message);
			} else {
				sw.write("空指针异常！");
			}
		} finally {
			CloseUtil.close(pw);
			CloseUtil.close(sw);
		}
		return sw.toString();
	}

}
