package cn.elwy.common.exception;

import java.sql.SQLException;

/**
 * 自定义持久层操作异常类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class DaoException extends RunException {

	private static final long serialVersionUID = 1L;

	public DaoException(String message) {
		super(message);
	}

	public DaoException(Throwable cause) {
		super(cause);
		initErrorCode(cause);
	}

	public DaoException(String message, Throwable cause) {
		super(message, cause);
		initErrorCode(cause);
	}

	public DaoException(String message, String detailMsg) {
		super(message, detailMsg);
	}

	private void initErrorCode(Throwable cause) {
		if (cause instanceof SQLException) {
			this.errorCode = ((SQLException) cause).getErrorCode() + "";
		}
	}
}
