package cn.elwy.common.exception;

import java.sql.SQLException;

/**
 * 自定义连接异常类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class ConnException extends RunException {

	private static final long serialVersionUID = 7143993079578421337L;

	public ConnException(String message) {
		super(message);
	}

	public ConnException(Throwable cause) {
		super(cause);
		initErrorCode(cause);
	}

	public ConnException(String message, Throwable cause) {
		super(message, cause);
		initErrorCode(cause);
	}

	public ConnException(String message, String detailMsg) {
		super(message, detailMsg);
	}

	private void initErrorCode(Throwable cause) {
		if (cause instanceof SQLException) {
			this.errorCode = ((SQLException) cause).getErrorCode() + "";
		}
	}
}
