package cn.elwy.common.exception;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * 检查异常的顶级基类,用户自定义检查异常继承此类.
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class CheckedException extends Exception {

	private static final long serialVersionUID = 1L;

	/** 异常信息 */
	protected String message;
	/** 错误编码 */
	protected int errorCode;
	/** 异常级别 */
	protected MsgLevel msgLevel;

	/**
	 * 自定义运行时异常
	 * @param message 异常信息
	 */
	public CheckedException(String message) {
		super(message);
		this.message = message;
	}

	/**
	 * 自定义运行时异常
	 * @param cause 异常原因
	 */
	public CheckedException(Throwable cause) {
		super(cause);
	}

	/**
	 * 自定义运行时异常
	 * @param message 异常信息
	 * @param cause 异常原因
	 */
	public CheckedException(String message, Throwable cause) {
		super(message, cause);
		this.message = message;
	}

	/**
	 * 自定义运行时异常
	 * @param message 异常信息
	 * @param detailMsg 异常详细信息
	 */
	public CheckedException(String message, String detailMsg) {
		super(message, new Throwable(detailMsg));
		this.message = message;
	}

	/**
	 * 获取异常详细的堆栈信息
	 * @return 详细信息
	 */
	public String getDetailMessage() {
		StringWriter stringWriter = new StringWriter();
		PrintWriter printwriter = new PrintWriter(stringWriter);

		if (getCause() != null) {
			getCause().printStackTrace(printwriter);
		} else if (message != null) {
			printwriter.println(message);
		}
		return stringWriter.toString();
	}

	/**
	 * 获取错误编码
	 * @return 错误码
	 */
	public int getErrorCode() {
		return errorCode;
	}

	/**
	 * 设置异常错误编码
	 * @param errorCode 错误码
	 */
	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}

	/**
	 * 获取异常的级别
	 * @return 消息级别
	 */
	public MsgLevel getMsgLevel() {
		return msgLevel;
	}

	/**
	 * 设置异常的级别，可选值：NONE, SUCCESS, ERROR, INFORMATION, QUESTION, WARNING
	 * @param msgLevel 异常级别
	 */
	public void setMsgLevel(MsgLevel msgLevel) {
		this.msgLevel = msgLevel;
	}

}
