package cn.elwy.common.exception;

import java.sql.SQLException;

/**
 * 自定义业务逻辑异常类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class BizException extends RunException {

	private static final long serialVersionUID = 1L;

	public BizException(String message) {
		super(message);
	}

	public BizException(Throwable cause) {
		super(cause);
		initErrorCode(cause);
	}

	public BizException(String message, Throwable cause) {
		super(message, cause);
		initErrorCode(cause);
	}

	public BizException(String message, String detailMsg) {
		super(message, detailMsg);
	}

	private void initErrorCode(Throwable cause) {
		if (cause instanceof SQLException) {
			this.errorCode = ((SQLException) cause).getErrorCode() + "";
		}
	}
}
