package cn.elwy.common.entity;

import java.util.ArrayList;
import java.util.List;

/**
 * 树实体类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class TreeEntity extends CommonEntity implements TreeNode {

	private static final long serialVersionUID = 1L;

	protected String id; // ID
	protected String code; // 编码
	protected String name; // 名称
	protected String type; // 类型
	protected Integer order = 0; // 显示次序
	protected String parentId; // 上级ID
	protected Integer level = 0; // 层级
	protected Integer subnum = 0; // 子节点个数
	protected String icon; // 图标
	protected boolean expanded = false;
	protected boolean leaf;
	protected boolean loaded = true;
	protected Long lvalue; // 左值
	protected Long rvalue; // 右值
	protected List<TreeNode> children = new ArrayList<TreeNode>();

	public TreeEntity() {
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getOrder() {
		return order;
	}

	public void setOrder(Integer order) {
		this.order = order;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public Integer getLevel() {
		return level;
	}

	public void setLevel(Integer level) {
		this.level = level;
	}

	public Integer getSubnum() {
		return subnum;
	}

	public void setSubnum(Integer subnum) {
		this.subnum = subnum;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public boolean isExpanded() {
		return expanded;
	}

	public void setExpanded(boolean expanded) {
		this.expanded = expanded;
	}

	public boolean isLeaf() {
		return leaf;
	}

	public void setLeaf(boolean leaf) {
		this.leaf = leaf;
	}

	public boolean isLoaded() {
		return loaded;
	}

	public void setLoaded(boolean loaded) {
		this.loaded = loaded;
	}

	public Long getLvalue() {
		return lvalue;
	}

	public void setLvalue(Long lvalue) {
		this.lvalue = lvalue;
	}

	public Long getRvalue() {
		return rvalue;
	}

	public void setRvalue(Long rvalue) {
		this.rvalue = rvalue;
	}

	public void addChild(TreeNode treeNode) {
		if (children == null) {
			children = new ArrayList<TreeNode>();
		}
		children.add(treeNode);
	}

	public void removeChild(TreeNode treeNode) {
		if (children != null) {
			children.remove(treeNode);
		}
	}

	@SuppressWarnings("unchecked")
	public <E extends TreeNode> List<E> getChildren() {
		return (List<E>) children;
	}

	@SuppressWarnings("unchecked")
	public <E extends TreeNode> void setChildren(List<E> children) {
		this.children = (List<TreeNode>) children;
	}

}
