package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import cn.elwy.common.PropertyConstant;
import cn.elwy.common.exception.ExceptionSupport;

/**
 * 统一输出对象，以JSON的形式输出到前端
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@SuppressWarnings("unchecked")
public class ResultDto extends LinkedHashMap<String, Object> implements Serializable, PropertyConstant {

	private static final long serialVersionUID = 1L;

	public ResultDto() {
		initValue();
	}

	public <E> ResultDto(List<E> datas) {
		initValue();
		setDatas(datas);
	}

	public <E> ResultDto(E data) {
		initValue();
		setData(data);
	}

	public void initValue() {
		setSuccess(true);
		setStatusCode(200);
	}

	public boolean isSuccess() {
		Boolean success = (Boolean) get(SUCCESS);
		return success == null || success == true;
	}

	public void setSuccess(boolean success) {
		put(SUCCESS, success);
	}

	public Integer getStatusCode() {
		return (Integer) get(STATUS_CODE);
	}

	public void setStatusCode(int statusCode) {
		put(STATUS_CODE, statusCode);
	}

	public String getState() {
		return (String) get(STATE);
	}

	public void setState(String state) {
		put(STATE, state);
	}

	public <E> E getData() {
		return (E) get(DATA);
	}

	public <E> void setData(E data) {
		put(DATA, data);
	}

	public <E> List<E> getDatas() {
		return (List<E>) get(DATAS);
	}

	public <E> void setDatas(List<E> datas) {
		put(DATAS, datas);
	}

	public String getOperate() {
		return (String) get(OPERATE);
	}

	public void setOperate(String operate) {
		put(OPERATE, operate);
	}

	public Integer getPageNo() {
		return (Integer) get(PAGE_NO);
	}

	public void setPageNo(Integer pageNo) {
		put(PAGE_NO, pageNo);
	}

	public Long getTotalRecord() {
		return (Long) get(TOTAL_RECORD);
	}

	public void setTotalRecord(Long totalRecord) {
		put(TOTAL_RECORD, totalRecord);
	}

	public Long getTotalPage() {
		return (Long) get(TOTAL_PAGE);
	}

	public void setTotalPage(Integer totalPage) {
		put(TOTAL_PAGE, totalPage);
	}

	public Integer getPageSize() {
		return (Integer) get(PAGE_SIZE);
	}

	public void setPageSize(Integer pageSize) {
		put(PAGE_SIZE, pageSize);
	}

	public String getMessage() {
		return (String) get(MESSAGE);
	}

	public void setMessage(String message) {
		put(MESSAGE, message);
	}

	public String getDetailMessage() {
		return (String) get(DETAIL_MESSAGE);
	}

	public void setDetailMesssage(String detailMessage) {
		put(DETAIL_MESSAGE, detailMessage);
	}

	public void setDetailMesssage(Throwable e) {
		String detailMessage = ExceptionSupport.getDetailMessage(e);
		put(DETAIL_MESSAGE, detailMessage);
	}

	public List<OrderRule> getOrderRules() {
		return (List<OrderRule>) get(ORDER_RULES);
	}

	public void setOrderRules(List<OrderRule> orderRules) {
		put(ORDER_RULES, orderRules);
	}

	public List<Criteria> getCriterias() {
		return (List<Criteria>) get(CRITERIAS);
	}

	public void setCriterias(List<Criteria> criterias) {
		if (criterias != null) {
			put(CRITERIAS, criterias);
		}
	}

	public List<String> getReadlonyColumns() {
		return (List<String>) get(READLONY_COLUMNS);
	}

	public void setReadlonyColumns(List<String> filterColumns) {
		put(READLONY_COLUMNS, filterColumns);
	}

	public List<String> getFilterColumns() {
		return (List<String>) get(FILTER_COLUMNS);
	}

	public void setFilterColumns(List<String> filterColumns) {
		put(FILTER_COLUMNS, filterColumns);
	}

	public Serializable getId() {
		return (Serializable) get(ID);
	}

	public void setId(Serializable id) {
		put(ID, id);
	}

	public List<String> getIds() {
		return (List<String>) get(IDS);
	}

	public void setIds(List<String> ids) {
		put(IDS, ids);
	}

	public Map<String, Object> getParam() {
		return (Map<String, Object>) get(PARAM);
	}

	public void setParam(Map<String, Object> param) {
		put(PARAM, param);
	}

	public void addParam(String key, Object value) {
		Map<String, Object> param = getParam();
		if (param != null) {
			param.put(key, value);
		}
	}

}
