package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.Collection;

/**
 * 查询规则类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class QueryRule implements Serializable {

	private static final long serialVersionUID = 1L;

	private String field;
	private String op;
	private Object value;
	private Object secondValue;
	private int valueSize;
	private String widgetType;

	public QueryRule() {
	}

	public QueryRule(String field, SqlOP op, WidgetType widgetType, Object value) {
		this(field, op, widgetType, value, null);
	}

	public QueryRule(String field, SqlOP op, WidgetType widgetType, Object value, Object secondValue) {
		this(field, op.toString(), widgetType.toString(), value, secondValue);
	}

	public QueryRule(String field, String op, String widgetType, Object value, Object secondValue) {
		this.field = field;
		this.op = op;
		this.widgetType = widgetType;
		this.setValue(value, secondValue);
	}

	public String getField() {
		return field;
	}

	public void setField(String field) {
		this.field = field;
	}

	public String getOp() {
		return op;
	}

	public void setOp(String op) {
		this.op = op;
	}

	public String getWidgetType() {
		return widgetType;
	}

	public void setWidgetType(String type) {
		this.widgetType = type;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.setValue(value, null);
	}

	public void setValue(Object value, Object secondValue) {
		if (value == null) {
			this.valueSize = 0;
		} else if (secondValue != null) {
			this.valueSize = 2;
		} else if (value instanceof Collection<?>) {
			this.valueSize = ((Collection<?>) value).size();
		} else if (value instanceof Object[]) {
			this.valueSize = ((Object[]) value).length;
		} else {
			this.valueSize = 1;
		}
		this.value = value;
		this.secondValue = secondValue;
	}

	public Object getSecondValue() {
		return secondValue;
	}

	public boolean isNoValue() {
		return valueSize == 0;
	}

	public boolean isSingleValue() {
		return valueSize == 1;
	}

	public boolean isBetweenValue() {
		return secondValue != null && valueSize == 2;
	}

	public boolean isCollectionValue() {
		return secondValue == null && valueSize >= 2;
	}

	public int getValueSize() {
		return valueSize;
	}

	@Override
	public String toString() {
		return "QueryRule [field=" + field + ", op=" + op + ", code=" + value + ", secondValue=" + secondValue
				+ ", valueSize=" + valueSize + ", widgetType=" + widgetType + "]";
	}

	/**
	 * Sql操作关键字
	 * @author huangsq
	 * @version 1.0, 2016-05-01
	 */
	public static enum SqlOP {

		IN(" IN ", "IN") {
		},
		NOT_IN(" NOT IN ", "NOT IN") {
		},
		IS_NULL(" IS NULL ", "IS NULL") {
		},
		IS_NOT_NULL(" IS NOT NULL ", "IS NOT NULL") {
		},
		BETWEEN(" BETWEEN ", "BETWEEN") {
		},
		NOT_BETWEEN(" NOT BETWEEN ", "NOT BETWEEN") {
		},
		LIKE(" LIKE ", "LIKE") {
		},
		NOT_LIKE(" NOT LIKE ", "NOT LIKE") {
		},
		GT(">", "GT") {
		},
		GE(">=", "GE") {
		},
		LT("<", "LT") {
		},
		LE("<=", "LE") {
		},
		EQUAL("=", "EQUAL") {
		},
		NOT_EQUAL("<>", "NOT EQUAL") {
		};

		private String code;
		private String name;

		private SqlOP(String code, String name) {
			this.code = code;
			this.name = name;
		}

		public String getCode() {
			return code;
		}

		public String getName() {
			return name;
		}

		@Override
		public String toString() {
			return code;
		}
	}

	/**
	 * 控件类型
	 * @author huangsq
	 * @version 1.0, 2016-05-01
	 */
	public static enum WidgetType {

		TEXT("TEXT", "TEXT") {
		},
		NUMBER("NUMBER", "NUMBER") {
		};

		private String code;
		private String name;

		private WidgetType(String code, String name) {
			this.code = code;
			this.name = name;
		}

		public String getCode() {
			return code;
		}

		public String getName() {
			return name;
		}

		@Override
		public String toString() {
			return code;
		}
	}

}