package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.elwy.common.PropertyConstant;

/**
 * 参数实体类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@SuppressWarnings("unchecked")
public class Parameter extends HashMap<String, Object> implements Serializable, PropertyConstant {

	private static final long serialVersionUID = 1L;

	public Parameter() {
		setCriterias(new ArrayList<Criteria>());
		setParam(new HashMap<String, Object>());
	}

	public String getOperate() {
		return (String) get(OPERATE);
	}

	public void setOperate(String operate) {
		put(OPERATE, operate);
	}

	/**
	 * 实体对象
	 * @return
	 */
	public <E> E getData() {
		return (E) get(DATA);
	}

	public <E> void setData(E entity) {
		put(DATA, entity);
	}

	/**
	 * 实体对象列表
	 * @return
	 */
	public <E> List<E> getDatas() {
		return (List<E>) get(DATAS);
	}

	public <E> void setDatas(List<E> entity) {
		put(DATAS, entity);
	}

	public Integer getPageNo() {
		return (Integer) get(PAGE_NO);
	}

	public void setPageNo(Integer pageNo) {
		put(PAGE_NO, pageNo);
	}

	public Integer getPageSize() {
		return (Integer) get(PAGE_SIZE);
	}

	public void setPageSize(Integer pageSize) {
		put(PAGE_SIZE, pageSize);
	}

	public String getOrderBy() {
		return (String) get(ORDER_BY);
	}

	public void setOrderBy(String orderBy) {
		put(ORDER_BY, orderBy);
	}

	public String getContextPath() {
		return (String) get(CONTEXT_PATH);
	}

	public void setContextPath(String contextPath) {
		put(CONTEXT_PATH, contextPath);
	}

	// public String getOrderDesc() {
	// return (String) get(ORDER_DESC);
	// }
	//
	// public void setOrderDesc(String desc) {
	// put(ORDER_DESC, desc);
	// }

	public List<OrderRule> getOrderRules() {
		return (List<OrderRule>) get(ORDER_RULES);
	}

	public void setOrderRules(List<OrderRule> orderRules) {
		put(ORDER_RULES, orderRules);
	}

	public List<Criteria> getCriterias() {
		return (List<Criteria>) get(CRITERIAS);
	}

	public void setCriterias(List<Criteria> criterias) {
		if (criterias != null) {
			put(CRITERIAS, criterias);
		}
	}

	public List<String> getFilterColumns() {
		return (List<String>) get(FILTER_COLUMNS);
	}

	public void setFilterColumns(List<String> filterColumns) {
		put(FILTER_COLUMNS, filterColumns);
	}

	public String getId() {
		return (String) get(ID);
	}

	public void setId(String id) {
		put(ID, id);
	}

	public String[] getIds() {
		return (String[]) get(IDS);
	}

	public void setIds(String... ids) {
		put(IDS, ids);
	}

	/**
	 * 查询条件
	 * @return
	 */
	public Map<String, Object> getParam() {
		return (Map<String, Object>) get(PARAM);
	}

	public void setParam(Map<String, Object> param) {
		put(PARAM, param);
	}

	public void addParam(String key, Object value) {
		Map<String, Object> param = getParam();
		param.put(key, value);
	}


	public void clear() {
		put(CRITERIAS, null);
		put(ORDER_RULES, null);
		super.clear();
	}

	@Override
	public String toString() {
		return "Parameter [getOperate()=" + getOperate() + ", getPageNo()=" + getPageNo() + ", getPageSize()="
				+ getPageSize() + ", getOrderBy()=" + getOrderBy() + ", getOrderRules()=" + getOrderRules()
				+ ", getCriterias()=" + getCriterias() + ", getFilterColumns()=" + getFilterColumns() + ", getId()=" + getId()
				+ ", getIds()=" + Arrays.toString(getIds()) + ", getParam()=" + getParam() + "]";
	}

}
