package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.List;

public interface Pageable<E> extends Serializable {

	/**
	 * 设置分页信息
	 * @param pageNo 当前页
	 * @param pageSize 每页大小
	 */
	public void setPage(int pageNo, int pageSize);

	/**
	 * 获得当前页的页码,序号从1开始,默认为1
	 */
	int getPageNo();

	/**
	 * 获得每页的大小
	 */
	int getPageSize();

	/**
	 * 取得总记录数, 默认值为-1
	 */
	long getTotalRecord();

	/**
	 * 设置总记录数
	 */
	void setTotalRecord(long totalRecord);

	/**
	 * 获取总页数
	 */
	int getTotalPage();

	/**
	 * 根据pageNo和pageSize计算当前页第一条记录在总结果集中的位置,序号从0开始.
	 */
	int getOffset();

	/**
	 * 获取每页记录数
	 */
	int getLimit();

	/**
	 * 取得分页后的记录列表.
	 */
	List<E> getDatas();

	/**
	 * 设置分页后的记录列表.
	 */
	void setDatas(List<E> datas);

}
